/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.util;

import java.util.Arrays;
import java.util.Collection;
import java.util.Properties;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.qpid.server.configuration.ServerConfiguration;
import org.apache.qpid.server.configuration.VirtualHostConfiguration;
import org.apache.qpid.server.management.NoopManagedObjectRegistry;
import org.apache.qpid.server.plugins.PluginManager;
import org.apache.qpid.server.registry.ApplicationRegistry;
import org.apache.qpid.server.security.access.ACLManager;
import org.apache.qpid.server.security.access.plugins.AllowAll;
import org.apache.qpid.server.security.auth.database.PropertiesPrincipalDatabaseManager;
import org.apache.qpid.server.security.auth.manager.PrincipalDatabaseAuthenticationManager;
import org.apache.qpid.server.virtualhost.VirtualHost;
import org.apache.qpid.server.virtualhost.VirtualHostRegistry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NullApplicationRegistry
extends ApplicationRegistry {
    public NullApplicationRegistry() throws ConfigurationException {
        super(new ServerConfiguration((Configuration)new PropertiesConfiguration()));
    }

    @Override
    public void initialise() throws Exception {
        _logger.info((Object)"Initialising NullApplicationRegistry");
        this._configuration.setHousekeepingExpiredMessageCheckPeriod(200L);
        Properties users = new Properties();
        users.put("guest", "guest");
        this._databaseManager = new PropertiesPrincipalDatabaseManager("default", users);
        this._accessManager = new ACLManager(this._configuration.getSecurityConfiguration(), this._pluginManager, AllowAll.FACTORY);
        this._authenticationManager = new PrincipalDatabaseAuthenticationManager(null, null);
        this._managedObjectRegistry = new NoopManagedObjectRegistry();
        this._virtualHostRegistry = new VirtualHostRegistry();
        PropertiesConfiguration vhostProps = new PropertiesConfiguration();
        VirtualHostConfiguration hostConfig = new VirtualHostConfiguration("test", (Configuration)vhostProps);
        VirtualHost dummyHost = new VirtualHost(hostConfig);
        this._virtualHostRegistry.registerVirtualHost(dummyHost);
        this._virtualHostRegistry.setDefaultVirtualHostName("test");
        this._pluginManager = new PluginManager("");
    }

    public Collection<String> getVirtualHostNames() {
        String[] hosts = new String[]{"test"};
        return Arrays.asList(hosts);
    }
}

