/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.virtualhost;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import javax.management.NotCompliantMBeanException;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.log4j.Logger;
import org.apache.qpid.AMQException;
import org.apache.qpid.framing.AMQShortString;
import org.apache.qpid.framing.FieldTable;
import org.apache.qpid.framing.abstraction.ContentChunk;
import org.apache.qpid.server.AMQBrokerManagerMBean;
import org.apache.qpid.server.configuration.ExchangeConfiguration;
import org.apache.qpid.server.configuration.QueueConfiguration;
import org.apache.qpid.server.configuration.VirtualHostConfiguration;
import org.apache.qpid.server.connection.ConnectionRegistry;
import org.apache.qpid.server.connection.IConnectionRegistry;
import org.apache.qpid.server.exchange.DefaultExchangeFactory;
import org.apache.qpid.server.exchange.DefaultExchangeRegistry;
import org.apache.qpid.server.exchange.Exchange;
import org.apache.qpid.server.exchange.ExchangeFactory;
import org.apache.qpid.server.exchange.ExchangeRegistry;
import org.apache.qpid.server.management.AMQManagedObject;
import org.apache.qpid.server.management.ManagedObject;
import org.apache.qpid.server.queue.AMQQueue;
import org.apache.qpid.server.queue.AMQQueueFactory;
import org.apache.qpid.server.queue.DefaultQueueRegistry;
import org.apache.qpid.server.queue.MessageMetaData;
import org.apache.qpid.server.queue.QueueRegistry;
import org.apache.qpid.server.registry.ApplicationRegistry;
import org.apache.qpid.server.security.access.ACLManager;
import org.apache.qpid.server.security.access.Accessable;
import org.apache.qpid.server.security.auth.manager.AuthenticationManager;
import org.apache.qpid.server.security.auth.manager.PrincipalDatabaseAuthenticationManager;
import org.apache.qpid.server.store.MessageStore;
import org.apache.qpid.server.store.StoreContext;
import org.apache.qpid.server.virtualhost.ManagedVirtualHost;

public class VirtualHost
implements Accessable {
    private static final Logger _logger = Logger.getLogger(VirtualHost.class);
    private final String _name;
    private ConnectionRegistry _connectionRegistry;
    private QueueRegistry _queueRegistry;
    private ExchangeRegistry _exchangeRegistry;
    private ExchangeFactory _exchangeFactory;
    private MessageStore _messageStore;
    protected VirtualHostMBean _virtualHostMBean;
    private AMQBrokerManagerMBean _brokerMBean;
    private AuthenticationManager _authenticationManager;
    private ACLManager _accessManager;
    private final Timer _houseKeepingTimer;
    private VirtualHostConfiguration _configuration;

    public void setAccessableName(String name) {
        _logger.warn((Object)("Setting Accessable Name for VirualHost is not allowed. (" + name + ") ignored remains :" + this.getAccessableName()));
    }

    public String getAccessableName() {
        return this._name;
    }

    public IConnectionRegistry getConnectionRegistry() {
        return this._connectionRegistry;
    }

    public VirtualHostConfiguration getConfiguration() {
        return this._configuration;
    }

    public VirtualHost(VirtualHostConfiguration hostConfig) throws Exception {
        this(hostConfig, null);
    }

    public VirtualHost(VirtualHostConfiguration hostConfig, MessageStore store) throws Exception {
        this._configuration = hostConfig;
        this._name = hostConfig.getName();
        if (this._name == null || this._name.length() == 0) {
            throw new IllegalArgumentException("Illegal name (" + this._name + ") for virtualhost.");
        }
        this._virtualHostMBean = new VirtualHostMBean();
        this._connectionRegistry = new ConnectionRegistry(this);
        this._houseKeepingTimer = new Timer("Queue-housekeeping-" + this._name, true);
        this._queueRegistry = new DefaultQueueRegistry(this);
        this._exchangeFactory = new DefaultExchangeFactory(this);
        this._exchangeFactory.initialise(hostConfig);
        this._exchangeRegistry = new DefaultExchangeRegistry(this);
        StartupRoutingTable configFileRT = new StartupRoutingTable();
        this._messageStore = configFileRT;
        this._exchangeRegistry.initialise();
        configFileRT.exchange.clear();
        this.initialiseModel(hostConfig);
        if (store != null) {
            this._messageStore = store;
        } else {
            if (hostConfig == null) {
                throw new IllegalAccessException("HostConfig and MessageStore cannot be null");
            }
            this.initialiseMessageStore(hostConfig);
        }
        for (StartupRoutingTable.CreateQueueTuple cqt : configFileRT.queue) {
            this._messageStore.createQueue(cqt.queue, cqt.arguments);
        }
        for (Exchange exchange : configFileRT.exchange) {
            this._messageStore.createExchange(exchange);
        }
        for (StartupRoutingTable.CreateBindingTuple cbt : configFileRT.bindings) {
            this._messageStore.bindQueue(cbt.exchange, cbt.routingKey, cbt.queue, cbt.arguments);
        }
        this._authenticationManager = new PrincipalDatabaseAuthenticationManager(this._name, hostConfig);
        this._accessManager = ApplicationRegistry.getInstance().getAccessManager();
        this._accessManager.configureHostPlugins(hostConfig.getSecurityConfiguration());
        this._brokerMBean = new AMQBrokerManagerMBean(this._virtualHostMBean);
        this._brokerMBean.register();
        this.initialiseHouseKeeping(hostConfig.getHousekeepingExpiredMessageCheckPeriod());
    }

    private void initialiseHouseKeeping(long period) {
        if (period != 0L) {
            class RemoveExpiredMessagesTask
            extends TimerTask {
                RemoveExpiredMessagesTask() {
                }

                public void run() {
                    for (AMQQueue q : VirtualHost.this._queueRegistry.getQueues()) {
                        try {
                            q.checkMessageStatus();
                        }
                        catch (AMQException e) {
                            _logger.error((Object)("Exception in housekeeping for queue: " + q.getName().toString()), (Throwable)e);
                            throw new RuntimeException(e);
                        }
                    }
                }
            }
            this._houseKeepingTimer.scheduleAtFixedRate((TimerTask)new RemoveExpiredMessagesTask(), period / 2L, period);
        }
    }

    private void initialiseMessageStore(VirtualHostConfiguration hostConfig) throws Exception {
        String messageStoreClass = hostConfig.getMessageStoreClass();
        Class<?> clazz = Class.forName(messageStoreClass);
        Object o = clazz.newInstance();
        if (!(o instanceof MessageStore)) {
            throw new ClassCastException("Message store class must implement " + MessageStore.class + ". Class " + clazz + " does not.");
        }
        MessageStore messageStore = (MessageStore)o;
        messageStore.configure(this, "store", hostConfig);
        this._messageStore = messageStore;
    }

    private void initialiseModel(VirtualHostConfiguration config) throws ConfigurationException, AMQException {
        String[] queueNames;
        _logger.debug((Object)("Loading configuration for virtualhost: " + config.getName()));
        List exchangeNames = config.getExchanges();
        for (Object exchangeNameObj : exchangeNames) {
            String exchangeName = String.valueOf(exchangeNameObj);
            this.configureExchange(config.getExchangeConfiguration(exchangeName));
        }
        for (String queueNameObj : queueNames = config.getQueueNames()) {
            String queueName = String.valueOf(queueNameObj);
            this.configureQueue(config.getQueueConfiguration(queueName));
        }
    }

    private void configureExchange(ExchangeConfiguration exchangeConfiguration) throws AMQException {
        AMQShortString exchangeName = new AMQShortString(exchangeConfiguration.getName());
        Exchange exchange = this._exchangeRegistry.getExchange(exchangeName);
        if (exchange == null) {
            AMQShortString type = new AMQShortString(exchangeConfiguration.getType());
            boolean durable = exchangeConfiguration.getDurable();
            boolean autodelete = exchangeConfiguration.getAutoDelete();
            Exchange newExchange = this._exchangeFactory.createExchange(exchangeName, type, durable, autodelete, 0);
            this._exchangeRegistry.registerExchange(newExchange);
        }
    }

    private void configureQueue(QueueConfiguration queueConfiguration) throws AMQException, ConfigurationException {
        String exchangeName;
        Exchange exchange;
        AMQQueue queue = AMQQueueFactory.createAMQQueueImpl(queueConfiguration, this);
        if (queue.isDurable()) {
            this._messageStore.createQueue(queue);
        }
        if ((exchange = this._exchangeRegistry.getExchange((exchangeName = queueConfiguration.getExchange()) == null ? null : new AMQShortString(exchangeName))) == null) {
            exchange = this._exchangeRegistry.getDefaultExchange();
        }
        if (exchange == null) {
            throw new ConfigurationException("Attempt to bind queue to unknown exchange:" + exchangeName);
        }
        List<AMQShortString> routingKeys = queueConfiguration.getRoutingKeys();
        if (routingKeys == null || routingKeys.isEmpty()) {
            routingKeys = Collections.singletonList(queue.getName());
        }
        for (AMQShortString routingKeyNameObj : routingKeys) {
            AMQShortString routingKey = new AMQShortString(String.valueOf(routingKeyNameObj));
            if (_logger.isInfoEnabled()) {
                _logger.info((Object)("Binding queue:" + queue + " with routing key '" + routingKey + "' to exchange:" + this));
            }
            queue.bind(exchange, routingKey, null);
        }
        if (exchange != this._exchangeRegistry.getDefaultExchange()) {
            queue.bind(this._exchangeRegistry.getDefaultExchange(), queue.getName(), null);
        }
    }

    public String getName() {
        return this._name;
    }

    public QueueRegistry getQueueRegistry() {
        return this._queueRegistry;
    }

    public ExchangeRegistry getExchangeRegistry() {
        return this._exchangeRegistry;
    }

    public ExchangeFactory getExchangeFactory() {
        return this._exchangeFactory;
    }

    public ApplicationRegistry getApplicationRegistry() {
        throw new UnsupportedOperationException();
    }

    public MessageStore getMessageStore() {
        return this._messageStore;
    }

    public AuthenticationManager getAuthenticationManager() {
        return this._authenticationManager;
    }

    public ACLManager getAccessManager() {
        return this._accessManager;
    }

    public void close() throws Exception {
        this._connectionRegistry.close();
        if (this._queueRegistry != null) {
            for (AMQQueue queue : this._queueRegistry.getQueues()) {
                queue.stop();
            }
        }
        if (this._houseKeepingTimer != null) {
            this._houseKeepingTimer.cancel();
        }
        if (this._messageStore != null) {
            this._messageStore.close();
        }
    }

    public ManagedObject getBrokerMBean() {
        return this._brokerMBean;
    }

    public ManagedObject getManagedObject() {
        return this._virtualHostMBean;
    }

    private class StartupRoutingTable
    implements MessageStore {
        public List<Exchange> exchange = new LinkedList<Exchange>();
        public List<CreateQueueTuple> queue = new LinkedList<CreateQueueTuple>();
        public List<CreateBindingTuple> bindings = new LinkedList<CreateBindingTuple>();

        private StartupRoutingTable() {
        }

        public void configure(VirtualHost virtualHost, String base, VirtualHostConfiguration config) throws Exception {
        }

        public void close() throws Exception {
        }

        public void removeMessage(StoreContext storeContext, Long messageId) throws AMQException {
        }

        public void createExchange(Exchange exchange) throws AMQException {
            if (exchange.isDurable()) {
                this.exchange.add(exchange);
            }
        }

        public void removeExchange(Exchange exchange) throws AMQException {
        }

        public void bindQueue(Exchange exchange, AMQShortString routingKey, AMQQueue queue, FieldTable args) throws AMQException {
            if (exchange.isDurable() && queue.isDurable()) {
                this.bindings.add(new CreateBindingTuple(exchange, routingKey, queue, args));
            }
        }

        public void unbindQueue(Exchange exchange, AMQShortString routingKey, AMQQueue queue, FieldTable args) throws AMQException {
        }

        public void createQueue(AMQQueue queue) throws AMQException {
            this.createQueue(queue, null);
        }

        public void createQueue(AMQQueue queue, FieldTable arguments) throws AMQException {
            if (queue.isDurable()) {
                this.queue.add(new CreateQueueTuple(queue, arguments));
            }
        }

        public void removeQueue(AMQQueue queue) throws AMQException {
        }

        public void enqueueMessage(StoreContext context, AMQQueue queue, Long messageId) throws AMQException {
        }

        public void dequeueMessage(StoreContext context, AMQQueue queue, Long messageId) throws AMQException {
        }

        public void beginTran(StoreContext context) throws AMQException {
        }

        public void commitTran(StoreContext context) throws AMQException {
        }

        public void abortTran(StoreContext context) throws AMQException {
        }

        public boolean inTran(StoreContext context) {
            return false;
        }

        public Long getNewMessageId() {
            return null;
        }

        public void storeContentBodyChunk(StoreContext context, Long messageId, int index, ContentChunk contentBody, boolean lastContentBody) throws AMQException {
        }

        public void storeMessageMetaData(StoreContext context, Long messageId, MessageMetaData messageMetaData) throws AMQException {
        }

        public MessageMetaData getMessageMetaData(StoreContext context, Long messageId) throws AMQException {
            return null;
        }

        public ContentChunk getContentBodyChunk(StoreContext context, Long messageId, int index) throws AMQException {
            return null;
        }

        public boolean isPersistent() {
            return false;
        }

        private class CreateBindingTuple {
            public AMQQueue queue;
            public FieldTable arguments;
            public Exchange exchange;
            public AMQShortString routingKey;

            public CreateBindingTuple(Exchange exchange, AMQShortString routingKey, AMQQueue queue, FieldTable args) {
                this.exchange = exchange;
                this.routingKey = routingKey;
                this.queue = queue;
                this.arguments = args;
            }
        }

        private class CreateQueueTuple {
            public AMQQueue queue;
            public FieldTable arguments;

            public CreateQueueTuple(AMQQueue queue, FieldTable arguments) {
                this.queue = queue;
                this.arguments = arguments;
            }
        }
    }

    public class VirtualHostMBean
    extends AMQManagedObject
    implements ManagedVirtualHost {
        public VirtualHostMBean() throws NotCompliantMBeanException {
            super(ManagedVirtualHost.class, "VirtualHost", 1);
        }

        public String getObjectInstanceName() {
            return VirtualHost.this._name.toString();
        }

        public String getName() {
            return VirtualHost.this._name.toString();
        }

        public VirtualHost getVirtualHost() {
            return VirtualHost.this;
        }
    }
}

