/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.virtualhost;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.qpid.server.virtualhost.VirtualHost;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VirtualHostRegistry {
    private final Map<String, VirtualHost> _registry = new ConcurrentHashMap<String, VirtualHost>();
    private String _defaultVirtualHostName;

    public synchronized void registerVirtualHost(VirtualHost host) throws Exception {
        if (this._registry.containsKey(host.getName())) {
            throw new Exception("Virtual Host with name " + host.getName() + " already registered.");
        }
        this._registry.put(host.getName(), host);
    }

    public VirtualHost getVirtualHost(String name) {
        if (name == null || name.trim().length() == 0) {
            name = this.getDefaultVirtualHostName();
        }
        return this._registry.get(name);
    }

    private String getDefaultVirtualHostName() {
        return this._defaultVirtualHostName;
    }

    public void setDefaultVirtualHostName(String defaultVirtualHostName) {
        this._defaultVirtualHostName = defaultVirtualHostName;
    }

    public Collection<VirtualHost> getVirtualHosts() {
        return new ArrayList<VirtualHost>(this._registry.values());
    }
}

