/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.tools.messagestore.commands;

import java.io.UnsupportedEncodingException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.codec.binary.Hex;
import org.apache.mina.common.ByteBuffer;
import org.apache.qpid.framing.abstraction.ContentChunk;
import org.apache.qpid.server.queue.AMQMessage;
import org.apache.qpid.server.queue.QueueEntry;
import org.apache.qpid.server.queue.QueueEntryImpl;
import org.apache.qpid.tools.messagestore.MessageStoreTool;
import org.apache.qpid.tools.messagestore.commands.Show;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Dump
extends Show {
    private static final int LINE_SIZE = 8;
    private static final String DEFAULT_ENCODING = "utf-8";
    private static final boolean SPACE_BYTES = true;
    private static final String BYTE_SPACER = " ";
    private static final String NON_PRINTING_ASCII_CHAR = "?";
    protected boolean _content = true;

    public Dump(MessageStoreTool tool) {
        super(tool);
    }

    @Override
    public String help() {
        return "Dump selected message content. Default: show=content";
    }

    @Override
    public String usage() {
        return this.getCommand() + " [show=[all],[msgheaders],[_amqHeaders],[routing],[content]] [id=<msgid e.g. 1,2,4-10>]";
    }

    @Override
    public String getCommand() {
        return "dump";
    }

    @Override
    public void execute(String ... args) {
        assert (args.length > 0);
        assert (args[0].equals(this.getCommand()));
        if (args.length >= 2) {
            for (String arg : args) {
                if (!arg.startsWith("show=")) continue;
                this._content = arg.contains("content") || arg.contains("all");
            }
            this.parseArgs(args);
        }
        this.performShow();
    }

    @Override
    protected List<List> createMessageData(List<Long> msgids, List<QueueEntry> messages, boolean showHeaders, boolean showRouting, boolean showMessageHeaders) {
        LinkedList<List> display = new LinkedList<List>();
        LinkedList<String> hex = new LinkedList<String>();
        LinkedList<String> ascii = new LinkedList<String>();
        display.add(hex);
        display.add(ascii);
        for (QueueEntry entry : messages) {
            AMQMessage msg = entry.getMessage();
            if (!this.includeMsg(msg, msgids)) continue;
            hex.add("*divider");
            ascii.add("*divider");
            hex.add(Show.Columns.ID.name());
            ascii.add(msg.getMessageId().toString());
            hex.add("*divider");
            ascii.add("*divider");
            if (showRouting) {
                this.addShowInformation(hex, ascii, msg, "Routing Details", true, false, false);
            }
            if (showHeaders) {
                this.addShowInformation(hex, ascii, msg, "Headers", false, true, false);
            }
            if (showMessageHeaders) {
                this.addShowInformation(hex, ascii, msg, null, false, false, true);
            }
            hex.add("Content Body");
            ascii.add("");
            hex.add("*divider");
            ascii.add("*divider");
            Iterator<ContentChunk> bodies = msg.getContentBodyIterator();
            if (bodies.hasNext()) {
                hex.add("Hex");
                hex.add("*divider");
                ascii.add("ASCII");
                ascii.add("*divider");
                while (bodies.hasNext()) {
                    ContentChunk chunk = bodies.next();
                    ByteBuffer hexBuffer = chunk.getData().duplicate();
                    ByteBuffer charBuffer = hexBuffer.duplicate();
                    Hex hexencoder = new Hex();
                    while (hexBuffer.hasRemaining()) {
                        byte[] line = new byte[8];
                        int bufsize = hexBuffer.remaining();
                        if (bufsize < 8) {
                            hexBuffer.get(line, 0, bufsize);
                        } else {
                            bufsize = line.length;
                            hexBuffer.get(line);
                        }
                        byte[] encoded = hexencoder.encode(line);
                        try {
                            String encStr = new String(encoded, 0, bufsize * 2, DEFAULT_ENCODING);
                            String hexLine = "";
                            int strKength = encStr.length();
                            for (int c = 0; c < strKength; ++c) {
                                hexLine = hexLine + encStr.charAt(c);
                                if (c % 2 != 1) continue;
                                hexLine = hexLine + BYTE_SPACER;
                            }
                            hex.add(hexLine);
                        }
                        catch (UnsupportedEncodingException e) {
                            this._console.println(e.getMessage());
                            return null;
                        }
                    }
                    while (charBuffer.hasRemaining()) {
                        String asciiLine = "";
                        for (int pos = 0; pos < 8 && charBuffer.hasRemaining(); ++pos) {
                            byte ch = charBuffer.get();
                            asciiLine = this.isPrintable(ch) ? asciiLine + (char)ch : asciiLine + NON_PRINTING_ASCII_CHAR;
                            asciiLine = asciiLine + BYTE_SPACER;
                        }
                        ascii.add(asciiLine);
                    }
                }
                continue;
            }
            LinkedList<String> result = new LinkedList<String>();
            display.add(result);
            result.add("No ContentBodies");
        }
        if (hex.size() == 0) {
            return null;
        }
        return display;
    }

    private void addShowInformation(List<String> column1, List<String> column2, AMQMessage msg, String title, boolean routing, boolean headers, boolean messageHeaders) {
        LinkedList<QueueEntry> single = new LinkedList<QueueEntry>();
        single.add(new QueueEntryImpl(null, msg, Long.MIN_VALUE));
        List<List> routingData = super.createMessageData(null, single, headers, routing, messageHeaders);
        if (title != null) {
            column1.add(title);
            column2.add("");
            column1.add("*divider");
            column2.add("*divider");
        }
        for (List item : routingData) {
            String columnName;
            if (item.size() != 3 || (columnName = item.get(0).toString()).equals(Show.Columns.ID.name()) || columnName.equals(Show.Columns.Size.name())) continue;
            column1.add(columnName);
            column2.add(item.get(2).toString());
        }
        column1.add("*divider");
        column2.add("*divider");
    }

    private boolean isPrintable(byte c) {
        return c > 31 && c < 127;
    }
}

