/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.tools.messagestore.commands;

import java.util.Collection;
import java.util.LinkedList;
import org.apache.qpid.framing.AMQShortString;
import org.apache.qpid.server.exchange.Exchange;
import org.apache.qpid.server.queue.AMQQueue;
import org.apache.qpid.server.registry.ApplicationRegistry;
import org.apache.qpid.server.virtualhost.VirtualHost;
import org.apache.qpid.tools.messagestore.MessageStoreTool;
import org.apache.qpid.tools.messagestore.commands.AbstractCommand;
import org.apache.qpid.tools.utils.Console;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class List
extends AbstractCommand {
    public List(MessageStoreTool tool) {
        super(tool);
    }

    @Override
    public void setOutput(Console out) {
        this._console = out;
    }

    @Override
    public String help() {
        return "list available items.";
    }

    @Override
    public String usage() {
        return "list queues [<exchange>] | exchanges | bindings [<exchange>] | all";
    }

    @Override
    public String getCommand() {
        return "list";
    }

    @Override
    public void execute(String ... args) {
        assert (args.length > 0);
        assert (args[0].equals(this.getCommand()));
        if (args.length > 1) {
            if (args[1].equals("exchanges") || args[1].equals("queues") || args[1].equals("bindings") || args[1].equals("all")) {
                if (args.length == 2) {
                    this.doList(args[1]);
                } else if (args.length == 3) {
                    this.doList(args[1], args[2]);
                }
            } else {
                this.commandError("Unknown options. ", args);
            }
        } else if (args.length < 2) {
            this.doList("all");
        } else {
            this.doList(args[1]);
        }
    }

    private void doList(String ... listItem) {
        Exchange exchange;
        if (this._tool.getState().getVhost() == null) {
            this._console.println("No Virtualhost open. Open a Virtualhost first.");
            this.listVirtualHosts();
            return;
        }
        VirtualHost vhost = this._tool.getState().getVhost();
        java.util.List<String> data = null;
        if (listItem[0].equals("queues")) {
            if (listItem.length > 1) {
                data = this.listQueues(vhost, new AMQShortString(listItem[1]));
            } else {
                exchange = this._tool.getState().getExchange();
                data = this.listQueues(vhost, exchange);
            }
        }
        if (listItem[0].equals("exchanges")) {
            data = this.listExchanges(vhost);
        }
        if (listItem[0].equals("bindings")) {
            if (listItem.length > 1) {
                data = this.listBindings(vhost, new AMQShortString(listItem[1]));
            } else {
                exchange = this._tool.getState().getExchange();
                data = this.listBindings(vhost, exchange);
            }
        }
        if (data != null) {
            if (data.size() == 1) {
                this._console.println("No '" + listItem[0] + "' to display,");
            } else {
                this._console.displayList(true, data.toArray(new String[0]));
            }
        }
        if (listItem[0].equals("all")) {
            boolean displayed = false;
            Exchange exchange2 = this._tool.getState().getExchange();
            data = this.listQueues(vhost, exchange2);
            if (data != null) {
                displayed = true;
                this._console.displayList(true, data.toArray(new String[0]));
            }
            if (exchange2 == null && (data = this.listExchanges(vhost)) != null) {
                displayed = true;
                this._console.displayList(true, data.toArray(new String[0]));
            }
            if ((data = this.listBindings(vhost, exchange2)) != null) {
                displayed = true;
                this._console.displayList(true, data.toArray(new String[0]));
            }
            if (!displayed) {
                this._console.println("Nothing to list");
            }
        }
    }

    private void listVirtualHosts() {
        Collection<VirtualHost> vhosts = ApplicationRegistry.getInstance().getVirtualHostRegistry().getVirtualHosts();
        String[] data = new String[vhosts.size() + 1];
        data[0] = "Available VirtualHosts";
        int index = 1;
        for (VirtualHost vhost : vhosts) {
            data[index] = vhost.getName();
            ++index;
        }
        this._console.displayList(true, data);
    }

    private java.util.List<String> listBindings(VirtualHost vhost, AMQShortString exchangeName) {
        return this.listBindings(vhost, vhost.getExchangeRegistry().getExchange(exchangeName));
    }

    private java.util.List<String> listBindings(VirtualHost vhost, Exchange exchange) {
        Collection<AMQShortString> queues = vhost.getQueueRegistry().getQueueNames();
        if (queues == null || queues.size() == 0) {
            return null;
        }
        LinkedList<String> data = new LinkedList<String>();
        data.add("Current Bindings");
        for (AMQShortString queue : queues) {
            if (exchange != null) {
                if (!exchange.isBound(queue)) continue;
                data.add(queue.toString());
                continue;
            }
            data.add(queue.toString());
        }
        return data;
    }

    private java.util.List<String> listExchanges(VirtualHost vhost) {
        Collection<AMQShortString> queues = vhost.getExchangeRegistry().getExchangeNames();
        if (queues == null || queues.size() == 0) {
            return null;
        }
        LinkedList<String> data = new LinkedList<String>();
        data.add("Available Exchanges");
        for (AMQShortString queue : queues) {
            data.add(queue.toString());
        }
        return data;
    }

    private java.util.List<String> listQueues(VirtualHost vhost, AMQShortString exchangeName) {
        return this.listQueues(vhost, vhost.getExchangeRegistry().getExchange(exchangeName));
    }

    private java.util.List<String> listQueues(VirtualHost vhost, Exchange exchange) {
        Collection<AMQQueue> queues = vhost.getQueueRegistry().getQueues();
        if (queues == null || queues.size() == 0) {
            return null;
        }
        LinkedList<String> data = new LinkedList<String>();
        data.add("Available Queues");
        for (AMQQueue queue : queues) {
            if (exchange != null) {
                if (!exchange.isBound(queue)) continue;
                data.add(queue.getName().toString());
                continue;
            }
            data.add(queue.getName().toString());
        }
        if (exchange != null && queues.size() == 1) {
            return null;
        }
        return data;
    }
}

