/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.tools.messagestore.commands;

import java.util.LinkedList;
import java.util.List;
import org.apache.qpid.framing.AMQShortString;
import org.apache.qpid.server.queue.AMQQueue;
import org.apache.qpid.server.queue.QueueEntry;
import org.apache.qpid.server.store.StoreContext;
import org.apache.qpid.tools.messagestore.MessageStoreTool;
import org.apache.qpid.tools.messagestore.commands.AbstractCommand;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Move
extends AbstractCommand {
    protected StoreContext _storeContext = new StoreContext();

    public Move(MessageStoreTool tool) {
        super(tool);
    }

    @Override
    public String help() {
        return "Move messages between queues.";
    }

    @Override
    public String usage() {
        return "move to=<queue> [from=<queue>] [msgids=<msgids eg, 1,2,4-10>]";
    }

    @Override
    public String getCommand() {
        return "move";
    }

    @Override
    public void execute(String ... args) {
        AMQQueue toQueue = null;
        AMQQueue fromQueue = this._tool.getState().getQueue();
        List<Long> msgids = this._tool.getState().getMessages();
        if (args.length >= 2) {
            for (String arg : args) {
                String queueName;
                if (arg.startsWith("to=")) {
                    queueName = arg.substring(arg.indexOf("=") + 1);
                    toQueue = this._tool.getState().getVhost().getQueueRegistry().getQueue(new AMQShortString(queueName));
                }
                if (arg.startsWith("from=")) {
                    queueName = arg.substring(arg.indexOf("=") + 1);
                    fromQueue = this._tool.getState().getVhost().getQueueRegistry().getQueue(new AMQShortString(queueName));
                }
                if (!arg.startsWith("msgids=")) continue;
                String msgidStr = arg.substring(arg.indexOf("=") + 1);
                List<Long> currentIDs = this._tool.getState().getMessages();
                this._tool.getState().setMessages(msgidStr);
                msgids = this._tool.getState().getMessages();
                this._tool.getState().setMessages(currentIDs);
            }
        }
        if (!this.checkRequirements(fromQueue, toQueue, msgids)) {
            return;
        }
        this.processIDs(fromQueue, toQueue, msgids);
    }

    private void processIDs(AMQQueue fromQueue, AMQQueue toQueue, List<Long> msgids) {
        Long previous = null;
        Long start = null;
        if (msgids == null) {
            msgids = this.allMessageIDs(fromQueue);
        }
        if (msgids == null || msgids.size() == 0) {
            this._console.println("No Messages to move.");
            return;
        }
        for (long id : msgids) {
            if (previous != null) {
                if (id == previous + 1L) {
                    if (start == null) {
                        start = previous;
                    }
                } else if (start != null) {
                    this.doCommand(fromQueue, start, id, toQueue);
                    start = null;
                } else {
                    this.doCommand(fromQueue, id, id, toQueue);
                }
            }
            previous = id;
        }
        if (start != null) {
            this.doCommand(fromQueue, start, previous, toQueue);
        }
    }

    private List<Long> allMessageIDs(AMQQueue fromQueue) {
        List<QueueEntry> messages;
        LinkedList<Long> ids = new LinkedList<Long>();
        if (fromQueue != null && (messages = fromQueue.getMessagesOnTheQueue()) != null) {
            for (QueueEntry msg : messages) {
                ids.add(msg.getMessage().getMessageId());
            }
        }
        return ids;
    }

    protected boolean checkRequirements(AMQQueue fromQueue, AMQQueue toQueue, List<Long> msgids) {
        if (toQueue == null) {
            this._console.println("Destination queue not specifed.");
            this._console.println(this.usage());
            return false;
        }
        if (fromQueue == null) {
            this._console.println("Source queue not specifed.");
            this._console.println(this.usage());
            return false;
        }
        return true;
    }

    protected void doCommand(AMQQueue fromQueue, long start, long id, AMQQueue toQueue) {
        fromQueue.moveMessagesToAnotherQueue(start, id, toQueue.getName().toString(), this._storeContext);
    }
}

