/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.tools.messagestore.commands;

import java.util.LinkedList;
import java.util.List;
import org.apache.qpid.AMQException;
import org.apache.qpid.framing.AMQShortString;
import org.apache.qpid.framing.BasicContentHeaderProperties;
import org.apache.qpid.framing.FieldTable;
import org.apache.qpid.framing.abstraction.MessagePublishInfo;
import org.apache.qpid.server.queue.AMQMessage;
import org.apache.qpid.server.queue.AMQQueue;
import org.apache.qpid.server.queue.QueueEntry;
import org.apache.qpid.tools.messagestore.MessageStoreTool;
import org.apache.qpid.tools.messagestore.commands.AbstractCommand;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Show
extends AbstractCommand {
    protected boolean _amqHeaders = false;
    protected boolean _routing = false;
    protected boolean _msgHeaders = false;

    public Show(MessageStoreTool tool) {
        super(tool);
    }

    @Override
    public String help() {
        return "Shows the messages headers.";
    }

    @Override
    public String usage() {
        return this.getCommand() + " [show=[all],[msgheaders],[amqheaders],[routing]] [id=<msgid e.g. 1,2,4-10>]";
    }

    @Override
    public String getCommand() {
        return "show";
    }

    @Override
    public void execute(String ... args) {
        assert (args.length > 0);
        assert (args[0].equals(this.getCommand()));
        if (args.length < 2) {
            this.parseArgs("all");
        } else {
            this.parseArgs(args);
        }
        this.performShow();
    }

    protected void parseArgs(String ... args) {
        List<Long> msgids = null;
        if (args.length >= 2) {
            for (String arg : args) {
                if (arg.startsWith("show=")) {
                    this._msgHeaders = arg.contains("msgheaders") || arg.contains("all");
                    this._amqHeaders = arg.contains("amqheaders") || arg.contains("all");
                    boolean bl = this._routing = arg.contains("routing") || arg.contains("all");
                }
                if (!arg.startsWith("id=")) continue;
                this._tool.getState().setMessages(msgids);
            }
        }
    }

    protected void performShow() {
        if (this._tool.getState().getVhost() == null) {
            this._console.println("No Virtualhost selected. 'DuSelect' a Virtualhost first.");
            return;
        }
        AMQQueue _queue = this._tool.getState().getQueue();
        List<Long> msgids = this._tool.getState().getMessages();
        if (_queue != null) {
            List<QueueEntry> messages = _queue.getMessagesOnTheQueue();
            if (messages == null || messages.size() == 0) {
                this._console.println("No messages on queue");
                return;
            }
            List<List> data = this.createMessageData(msgids, messages, this._amqHeaders, this._routing, this._msgHeaders);
            if (data != null) {
                this._console.printMap(null, data);
            } else {
                String message = "No data to display.";
                if (msgids != null) {
                    message = message + " Is message selection correct? " + this._tool.getState().printMessages();
                }
                this._console.println(message);
            }
        } else {
            this._console.println("No Queue specified to show.");
        }
    }

    protected List<List> createMessageData(List<Long> msgids, List<QueueEntry> messages, boolean showHeaders, boolean showRouting, boolean showMessageHeaders) {
        LinkedList<List> data = new LinkedList<List>();
        LinkedList<String> id = new LinkedList<String>();
        data.add(id);
        id.add(Columns.ID.name());
        id.add("*divider");
        LinkedList<String> exchange = new LinkedList<String>();
        LinkedList<String> routingkey = new LinkedList<String>();
        LinkedList<String> immediate = new LinkedList<String>();
        LinkedList<String> mandatory = new LinkedList<String>();
        if (showRouting) {
            data.add(exchange);
            exchange.add(Columns.Exchange.name());
            exchange.add("*divider");
            data.add(routingkey);
            routingkey.add(Columns.RoutingKey.name());
            routingkey.add("*divider");
            data.add(immediate);
            immediate.add(Columns.isImmediate.name());
            immediate.add("*divider");
            data.add(mandatory);
            mandatory.add(Columns.isMandatory.name());
            mandatory.add("*divider");
        }
        LinkedList<String> size = new LinkedList<String>();
        LinkedList<String> appid = new LinkedList<String>();
        LinkedList<String> clusterid = new LinkedList<String>();
        LinkedList<String> contenttype = new LinkedList<String>();
        LinkedList<String> correlationid = new LinkedList<String>();
        LinkedList<String> deliverymode = new LinkedList<String>();
        LinkedList<String> encoding = new LinkedList<String>();
        LinkedList<String> arrival = new LinkedList<String>();
        LinkedList<String> expiration = new LinkedList<String>();
        LinkedList<String> priority = new LinkedList<String>();
        LinkedList<String> propertyflag = new LinkedList<String>();
        LinkedList<String> replyto = new LinkedList<String>();
        LinkedList<String> timestamp = new LinkedList<String>();
        LinkedList<String> type = new LinkedList<String>();
        LinkedList<String> userid = new LinkedList<String>();
        LinkedList<String> ispersitent = new LinkedList<String>();
        LinkedList<String> isredelivered = new LinkedList<String>();
        LinkedList<String> isdelivered = new LinkedList<String>();
        data.add(size);
        size.add(Columns.Size.name());
        size.add("*divider");
        if (showHeaders) {
            data.add(ispersitent);
            ispersitent.add(Columns.isPersistent.name());
            ispersitent.add("*divider");
            data.add(isredelivered);
            isredelivered.add(Columns.isRedelivered.name());
            isredelivered.add("*divider");
            data.add(isdelivered);
            isdelivered.add(Columns.isDelivered.name());
            isdelivered.add("*divider");
            data.add(appid);
            appid.add(Columns.App_ID.name());
            appid.add("*divider");
            data.add(clusterid);
            clusterid.add(Columns.Cluster_ID.name());
            clusterid.add("*divider");
            data.add(contenttype);
            contenttype.add(Columns.Content_Type.name());
            contenttype.add("*divider");
            data.add(correlationid);
            correlationid.add(Columns.Correlation_ID.name());
            correlationid.add("*divider");
            data.add(deliverymode);
            deliverymode.add(Columns.Delivery_Mode.name());
            deliverymode.add("*divider");
            data.add(encoding);
            encoding.add(Columns.Encoding.name());
            encoding.add("*divider");
            data.add(arrival);
            expiration.add(Columns.Arrival.name());
            expiration.add("*divider");
            data.add(expiration);
            expiration.add(Columns.Expiration.name());
            expiration.add("*divider");
            data.add(priority);
            priority.add(Columns.Priority.name());
            priority.add("*divider");
            data.add(propertyflag);
            propertyflag.add(Columns.Property_Flag.name());
            propertyflag.add("*divider");
            data.add(replyto);
            replyto.add(Columns.ReplyTo.name());
            replyto.add("*divider");
            data.add(timestamp);
            timestamp.add(Columns.Timestamp.name());
            timestamp.add("*divider");
            data.add(type);
            type.add(Columns.Type.name());
            type.add("*divider");
            data.add(userid);
            userid.add(Columns.UserID.name());
            userid.add("*divider");
        }
        LinkedList<String> msgHeaders = new LinkedList<String>();
        if (showMessageHeaders) {
            data.add(msgHeaders);
            msgHeaders.add(Columns.MsgHeaders.name());
            msgHeaders.add("*divider");
        }
        for (QueueEntry entry : messages) {
            AMQMessage msg = entry.getMessage();
            if (!this.includeMsg(msg, msgids)) continue;
            id.add(msg.getMessageId().toString());
            size.add("" + msg.getSize());
            arrival.add("" + msg.getArrivalTime());
            try {
                ispersitent.add(msg.isPersistent() ? "true" : "false");
            }
            catch (AMQException e) {
                ispersitent.add("n/a");
            }
            isredelivered.add(msg.isRedelivered() ? "true" : "false");
            isdelivered.add(msg.getDeliveredToConsumer() ? "true" : "false");
            BasicContentHeaderProperties headers = null;
            try {
                headers = (BasicContentHeaderProperties)msg.getContentHeaderBody().properties;
            }
            catch (AMQException e) {
                // empty catch block
            }
            if (headers == null) continue;
            String appidS = headers.getAppIdAsString();
            appid.add(appidS == null ? "null" : appidS);
            String clusterS = headers.getClusterIdAsString();
            clusterid.add(clusterS == null ? "null" : clusterS);
            String contentS = headers.getContentTypeAsString();
            contenttype.add(contentS == null ? "null" : contentS);
            String correlationS = headers.getCorrelationIdAsString();
            correlationid.add(correlationS == null ? "null" : correlationS);
            deliverymode.add("" + headers.getDeliveryMode());
            AMQShortString encodeSS = headers.getEncoding();
            encoding.add(encodeSS == null ? "null" : encodeSS.toString());
            expiration.add("" + headers.getExpiration());
            FieldTable headerFT = headers.getHeaders();
            msgHeaders.add(headerFT == null ? "none" : "" + headerFT.toString());
            priority.add("" + headers.getPriority());
            propertyflag.add("" + headers.getPropertyFlags());
            AMQShortString replytoSS = headers.getReplyTo();
            replyto.add(replytoSS == null ? "null" : replytoSS.toString());
            timestamp.add("" + headers.getTimestamp());
            AMQShortString typeSS = headers.getType();
            type.add(typeSS == null ? "null" : typeSS.toString());
            AMQShortString useridSS = headers.getUserId();
            userid.add(useridSS == null ? "null" : useridSS.toString());
            MessagePublishInfo info = null;
            try {
                info = msg.getMessagePublishInfo();
            }
            catch (AMQException e) {
                // empty catch block
            }
            if (info == null) continue;
            AMQShortString exchangeSS = info.getExchange();
            exchange.add(exchangeSS == null ? "null" : exchangeSS.toString());
            AMQShortString routingkeySS = info.getRoutingKey();
            routingkey.add(routingkeySS == null ? "null" : routingkeySS.toString());
            immediate.add(info.isImmediate() ? "true" : "false");
            mandatory.add(info.isMandatory() ? "true" : "false");
        }
        if (id.size() == 2) {
            return null;
        }
        return data;
    }

    protected boolean includeMsg(AMQMessage msg, List<Long> msgids) {
        if (msgids == null) {
            return true;
        }
        Long msgid = msg.getMessageId();
        boolean found = false;
        if (msgids != null) {
            for (Long l : msgids) {
                if (!l.equals(msgid)) continue;
                found = true;
                break;
            }
        }
        return found;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Columns {
        ID,
        Size,
        Exchange,
        RoutingKey,
        isImmediate,
        isMandatory,
        isPersistent,
        isRedelivered,
        isDelivered,
        App_ID,
        Cluster_ID,
        Content_Type,
        Correlation_ID,
        Delivery_Mode,
        Encoding,
        Arrival,
        Expiration,
        Priority,
        Property_Flag,
        ReplyTo,
        Timestamp,
        Type,
        UserID,
        MsgHeaders;

    }
}

