/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.client;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import org.apache.qpid.jms.BrokerDetails;
import org.apache.qpid.url.URLHelper;
import org.apache.qpid.url.URLSyntaxException;

public class AMQBrokerDetails
implements BrokerDetails {
    private String _host;
    private int _port;
    private String _transport;
    private HashMap<String, String> _options;

    public AMQBrokerDetails() {
        this._options = new HashMap();
    }

    public AMQBrokerDetails(String url) throws URLSyntaxException {
        this();
        try {
            URI connection = new URI(url);
            String transport = connection.getScheme();
            if (transport != null) {
                if (!transport.equalsIgnoreCase("vm") && !transport.equalsIgnoreCase("tcp")) {
                    if (transport.equalsIgnoreCase("localhost")) {
                        connection = new URI("tcp://" + url);
                        transport = connection.getScheme();
                    } else if (url.charAt(transport.length()) == ':' && url.charAt(transport.length() + 1) != '/') {
                        connection = new URI("tcp://" + url);
                        transport = connection.getScheme();
                    } else {
                        URLHelper.parseError((int)0, (int)transport.length(), (String)"Unknown transport", (String)url);
                    }
                }
            } else {
                connection = new URI("tcp://" + url);
                transport = connection.getScheme();
            }
            if (transport == null) {
                URLHelper.parseError((int)-1, (String)("Unknown transport:'" + transport + "'" + " In broker URL:'" + url + "' Format: " + "<transport>://<hostname>[:<port Default=\"5672\">][?<option>='<value>'[,<option>='<value>']]"), (String)"");
            }
            this.setTransport(transport);
            String host = connection.getHost();
            if (host == null) {
                host = "";
            }
            this.setHost(host);
            int port = connection.getPort();
            if (port == -1) {
                String auth = connection.getAuthority();
                if (auth != null && auth.startsWith(":")) {
                    this.setPort(Integer.parseInt(auth.substring(1)));
                } else {
                    this.setPort(5672);
                }
            } else {
                this.setPort(port);
            }
            String queryString = connection.getQuery();
            URLHelper.parseOptions(this._options, (String)queryString);
        }
        catch (URISyntaxException uris) {
            if (uris instanceof URLSyntaxException) {
                throw (URLSyntaxException)uris;
            }
            URLHelper.parseError((int)uris.getIndex(), (String)uris.getReason(), (String)uris.getInput());
        }
    }

    public AMQBrokerDetails(String host, int port, boolean useSSL) {
        this._host = host;
        this._port = port;
        if (useSSL) {
            this.setOption("ssl", "true");
        }
    }

    public String getHost() {
        return this._host;
    }

    public void setHost(String _host) {
        this._host = _host;
    }

    public int getPort() {
        return this._port;
    }

    public void setPort(int _port) {
        this._port = _port;
    }

    public String getTransport() {
        return this._transport;
    }

    public void setTransport(String _transport) {
        this._transport = _transport;
    }

    public String getOption(String key) {
        return this._options.get(key);
    }

    public void setOption(String key, String value) {
        this._options.put(key, value);
    }

    public long getTimeout() {
        if (this._options.containsKey("connecttimeout")) {
            try {
                return Long.parseLong(this._options.get("connecttimeout"));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return 30000L;
    }

    public void setTimeout(long timeout) {
        this.setOption("connecttimeout", Long.toString(timeout));
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this._transport);
        sb.append("://");
        if (!this._transport.equalsIgnoreCase("vm")) {
            sb.append(this._host);
        }
        sb.append(':');
        sb.append(this._port);
        sb.append(this.printOptionsURL());
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (!(o instanceof BrokerDetails)) {
            return false;
        }
        BrokerDetails bd = (BrokerDetails)o;
        return this._host.equalsIgnoreCase(bd.getHost()) && this._port == bd.getPort() && this._transport.equalsIgnoreCase(bd.getTransport()) && this.useSSL() == bd.useSSL();
    }

    private String printOptionsURL() {
        StringBuffer optionsURL = new StringBuffer();
        optionsURL.append('?');
        if (!this._options.isEmpty()) {
            for (String key : this._options.keySet()) {
                optionsURL.append(key);
                optionsURL.append("='");
                optionsURL.append(this._options.get(key));
                optionsURL.append("'");
                optionsURL.append(URLHelper.DEFAULT_OPTION_SEPERATOR);
            }
        }
        optionsURL.deleteCharAt(optionsURL.length() - 1);
        return optionsURL.toString();
    }

    public boolean useSSL() {
        if (this._options.containsKey("ssl")) {
            return this._options.get("ssl").equalsIgnoreCase("true");
        }
        return false;
    }

    public void useSSL(boolean ssl) {
        this.setOption("ssl", Boolean.toString(ssl));
    }
}

