/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.client;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;
import org.apache.qpid.client.AMQBrokerDetails;
import org.apache.qpid.client.AMQConnectionFactory;
import org.apache.qpid.jms.BrokerDetails;
import org.apache.qpid.jms.ConnectionURL;
import org.apache.qpid.url.URLHelper;
import org.apache.qpid.url.URLSyntaxException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AMQConnectionURL
implements ConnectionURL {
    private String _url;
    private String _failoverMethod;
    private HashMap<String, String> _failoverOptions;
    private HashMap<String, String> _options;
    private List<BrokerDetails> _brokers;
    private String _clientName;
    private String _username;
    private String _password;
    private String _virtualHost;

    public AMQConnectionURL(String fullURL) throws URLSyntaxException {
        this._url = fullURL;
        this._options = new HashMap();
        this._brokers = new LinkedList<BrokerDetails>();
        this._failoverOptions = new HashMap();
        try {
            URI connection = new URI(fullURL);
            if (connection.getScheme() == null || !connection.getScheme().equalsIgnoreCase("amqp")) {
                throw new URISyntaxException(fullURL, "Not an AMQP URL");
            }
            if (connection.getHost() == null || connection.getHost().equals("")) {
                String uid = AMQConnectionFactory.getUniqueClientID();
                if (uid == null) {
                    URLHelper.parseError((int)-1, (String)"Client Name not specified", (String)fullURL);
                } else {
                    this.setClientName(uid);
                }
            } else {
                this.setClientName(connection.getHost());
            }
            String userInfo = connection.getUserInfo();
            if (userInfo == null && (userInfo = connection.getAuthority()) != null) {
                int atIndex = userInfo.indexOf(64);
                userInfo = atIndex != -1 ? userInfo.substring(0, atIndex) : null;
            }
            if (userInfo == null) {
                URLHelper.parseError((int)("amqp".length() + 3), (String)"User information not found on url", (String)fullURL);
            } else {
                this.parseUserInfo(userInfo);
            }
            String virtualHost = connection.getPath();
            if (virtualHost != null && !virtualHost.equals("")) {
                this.setVirtualHost(virtualHost);
            } else {
                int authLength = connection.getAuthority().length();
                int start = "amqp".length() + 3;
                int testIndex = start + authLength;
                if (testIndex < fullURL.length() && fullURL.charAt(testIndex) == '?') {
                    URLHelper.parseError((int)start, (int)(testIndex - start), (String)"Virtual host found", (String)fullURL);
                } else {
                    URLHelper.parseError((int)-1, (String)"Virtual host not specified", (String)fullURL);
                }
            }
            URLHelper.parseOptions(this._options, (String)connection.getQuery());
            this.processOptions();
        }
        catch (URISyntaxException uris) {
            if (uris instanceof URLSyntaxException) {
                throw (URLSyntaxException)uris;
            }
            int slash = fullURL.indexOf("\\");
            if (slash == -1) {
                URLHelper.parseError((int)uris.getIndex(), (String)uris.getReason(), (String)uris.getInput());
            }
            if (slash != 0 && fullURL.charAt(slash - 1) == ':') {
                URLHelper.parseError((int)(slash - 2), (int)(fullURL.indexOf(63) - slash + 2), (String)"Virtual host looks like a windows path, forward slash not allowed in URL", (String)fullURL);
            }
            URLHelper.parseError((int)slash, (String)"Forward slash not allowed in URL", (String)fullURL);
        }
    }

    private void parseUserInfo(String userinfo) throws URLSyntaxException {
        int colonIndex = userinfo.indexOf(58);
        if (colonIndex == -1) {
            URLHelper.parseError((int)("amqp".length() + 3), (int)userinfo.length(), (String)"Null password in user information not allowed.", (String)this._url);
        } else {
            this.setUsername(userinfo.substring(0, colonIndex));
            this.setPassword(userinfo.substring(colonIndex + 1));
        }
    }

    private void processOptions() throws URLSyntaxException {
        if (this._options.containsKey("brokerlist")) {
            String brokerlist = this._options.get("brokerlist");
            StringTokenizer st = new StringTokenizer(brokerlist, "" + URLHelper.BROKER_SEPARATOR);
            while (st.hasMoreTokens()) {
                String broker = st.nextToken();
                this._brokers.add(new AMQBrokerDetails(broker));
            }
            this._options.remove("brokerlist");
        }
        if (this._options.containsKey("failover")) {
            String failover = this._options.get("failover");
            int methodIndex = failover.indexOf(63);
            if (methodIndex > -1) {
                this._failoverMethod = failover.substring(0, methodIndex);
                URLHelper.parseOptions(this._failoverOptions, (String)failover.substring(methodIndex + 1));
            } else {
                this._failoverMethod = failover;
            }
            this._options.remove("failover");
        }
    }

    @Override
    public String getURL() {
        return this._url;
    }

    @Override
    public String getFailoverMethod() {
        return this._failoverMethod;
    }

    @Override
    public String getFailoverOption(String key) {
        return this._failoverOptions.get(key);
    }

    public void setFailoverOption(String key, String value) {
        this._failoverOptions.put(key, value);
    }

    @Override
    public int getBrokerCount() {
        return this._brokers.size();
    }

    @Override
    public BrokerDetails getBrokerDetails(int index) {
        if (index < this._brokers.size()) {
            return this._brokers.get(index);
        }
        return null;
    }

    @Override
    public void addBrokerDetails(BrokerDetails broker) {
        if (!this._brokers.contains(broker)) {
            this._brokers.add(broker);
        }
    }

    @Override
    public List<BrokerDetails> getAllBrokerDetails() {
        return this._brokers;
    }

    @Override
    public String getClientName() {
        return this._clientName;
    }

    @Override
    public void setClientName(String clientName) {
        this._clientName = clientName;
    }

    @Override
    public String getUsername() {
        return this._username;
    }

    @Override
    public void setUsername(String username) {
        this._username = username;
    }

    @Override
    public String getPassword() {
        return this._password;
    }

    @Override
    public void setPassword(String password) {
        this._password = password;
    }

    @Override
    public String getVirtualHost() {
        return this._virtualHost;
    }

    @Override
    public void setVirtualHost(String virtuaHost) {
        this._virtualHost = virtuaHost;
    }

    @Override
    public String getOption(String key) {
        return this._options.get(key);
    }

    @Override
    public void setOption(String key, String value) {
        this._options.put(key, value);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("amqp");
        sb.append("://");
        if (this._username != null) {
            sb.append(this._username);
            if (this._password != null) {
                sb.append(':');
                sb.append(this._password);
            }
            sb.append('@');
        }
        sb.append(this._clientName);
        sb.append(this._virtualHost);
        sb.append(this.optionsToString());
        return sb.toString();
    }

    private String optionsToString() {
        StringBuffer sb = new StringBuffer();
        sb.append("?brokerlist='");
        for (BrokerDetails service : this._brokers) {
            sb.append(((Object)service).toString());
            sb.append(';');
        }
        sb.deleteCharAt(sb.length() - 1);
        sb.append("'");
        if (this._failoverMethod != null) {
            sb.append(URLHelper.DEFAULT_OPTION_SEPERATOR);
            sb.append("failover='");
            sb.append(this._failoverMethod);
            sb.append(URLHelper.printOptions(this._failoverOptions));
            sb.append("'");
        }
        return sb.toString();
    }

    public static void main(String[] args) throws URLSyntaxException {
        String url2 = "amqp://ritchiem:bob@temp?brokerlist='tcp://localhost:5672;jcp://fancyserver:3000/',failover='roundrobin'";
        AMQConnectionURL connectionurl2 = new AMQConnectionURL(url2);
        System.out.println(url2);
        System.out.println(connectionurl2);
    }
}

