/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.client;

import javax.jms.Destination;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.Referenceable;
import javax.naming.StringRefAddr;
import org.apache.qpid.client.AMQConnectionFactory;
import org.apache.qpid.url.AMQBindingURL;
import org.apache.qpid.url.BindingURL;
import org.apache.qpid.url.URLHelper;
import org.apache.qpid.url.URLSyntaxException;

public abstract class AMQDestination
implements Destination,
Referenceable {
    protected final String _exchangeName;
    protected final String _exchangeClass;
    protected final String _destinationName;
    protected boolean _isDurable;
    protected final boolean _isExclusive;
    protected final boolean _isAutoDelete;
    protected String _queueName;

    protected AMQDestination(String url) throws URLSyntaxException {
        this((BindingURL)new AMQBindingURL(url));
    }

    protected AMQDestination(BindingURL binding) {
        this._exchangeName = binding.getExchangeName();
        this._exchangeClass = binding.getExchangeClass();
        this._destinationName = binding.getDestinationName();
        this._isExclusive = Boolean.parseBoolean(binding.getOption("exclusive"));
        this._isAutoDelete = Boolean.parseBoolean(binding.getOption("autodelete"));
        this._isDurable = Boolean.parseBoolean(binding.getOption("durable"));
        this._queueName = binding.getQueueName();
    }

    protected AMQDestination(String exchangeName, String exchangeClass, String destinationName, String queueName) {
        this(exchangeName, exchangeClass, destinationName, false, false, queueName);
    }

    protected AMQDestination(String exchangeName, String exchangeClass, String destinationName) {
        this(exchangeName, exchangeClass, destinationName, false, false, null);
    }

    protected AMQDestination(String exchangeName, String exchangeClass, String destinationName, boolean isExclusive, boolean isAutoDelete, String queueName) {
        if (destinationName == null) {
            throw new IllegalArgumentException("Destination name must not be null");
        }
        if (exchangeName == null) {
            throw new IllegalArgumentException("Exchange name must not be null");
        }
        if (exchangeClass == null) {
            throw new IllegalArgumentException("Exchange class must not be null");
        }
        this._exchangeName = exchangeName;
        this._exchangeClass = exchangeClass;
        this._destinationName = destinationName;
        this._isExclusive = isExclusive;
        this._isAutoDelete = isAutoDelete;
        this._queueName = queueName;
    }

    public abstract String getEncodedName();

    public boolean isDurable() {
        return this._isDurable;
    }

    public String getExchangeName() {
        return this._exchangeName;
    }

    public String getExchangeClass() {
        return this._exchangeClass;
    }

    public boolean isTopic() {
        return "amq.topic".equals(this._exchangeName);
    }

    public boolean isQueue() {
        return "amq.direct".equals(this._exchangeName);
    }

    public String getDestinationName() {
        return this._destinationName;
    }

    public String getQueueName() {
        return this._queueName;
    }

    public void setQueueName(String queueName) {
        this._queueName = queueName;
    }

    public abstract String getRoutingKey();

    public boolean isExclusive() {
        return this._isExclusive;
    }

    public boolean isAutoDelete() {
        return this._isAutoDelete;
    }

    public abstract boolean isNameRequired();

    public String toString() {
        return this.toURL();
    }

    public String toURL() {
        StringBuffer sb = new StringBuffer();
        sb.append(this._exchangeClass);
        sb.append("://");
        sb.append(this._exchangeName);
        sb.append("/");
        if (this._destinationName != null) {
            sb.append(this._destinationName);
        }
        sb.append("/");
        if (this._queueName != null) {
            sb.append(this._queueName);
        }
        sb.append("?");
        if (this._isDurable) {
            sb.append("durable");
            sb.append("='true'");
            sb.append(URLHelper.DEFAULT_OPTION_SEPERATOR);
        }
        if (this._isExclusive) {
            sb.append("exclusive");
            sb.append("='true'");
            sb.append(URLHelper.DEFAULT_OPTION_SEPERATOR);
        }
        if (this._isAutoDelete) {
            sb.append("autodelete");
            sb.append("='true'");
            sb.append(URLHelper.DEFAULT_OPTION_SEPERATOR);
        }
        sb.deleteCharAt(sb.length() - 1);
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AMQDestination that = (AMQDestination)o;
        if (!this._destinationName.equals(that._destinationName)) {
            return false;
        }
        if (!this._exchangeClass.equals(that._exchangeClass)) {
            return false;
        }
        if (!this._exchangeName.equals(that._exchangeName)) {
            return false;
        }
        if (this._queueName == null && that._queueName != null || this._queueName != null && !this._queueName.equals(that._queueName)) {
            return false;
        }
        if (this._isExclusive != that._isExclusive) {
            return false;
        }
        return this._isAutoDelete == that._isAutoDelete;
    }

    public int hashCode() {
        int result = this._exchangeName.hashCode();
        result = 29 * result + this._exchangeClass.hashCode();
        result = 29 * result + this._destinationName.hashCode();
        if (this._queueName != null) {
            result = 29 * result + this._queueName.hashCode();
        }
        result *= this._isExclusive ? 13 : 7;
        return result *= this._isAutoDelete ? 13 : 7;
    }

    public Reference getReference() throws NamingException {
        return new Reference(this.getClass().getName(), new StringRefAddr(this.getClass().getName(), this.toURL()), AMQConnectionFactory.class.getName(), null);
    }
}

