/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.client;

import java.io.UnsupportedEncodingException;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import org.apache.log4j.Logger;
import org.apache.mina.common.ByteBuffer;
import org.apache.qpid.AMQException;
import org.apache.qpid.client.AMQConnection;
import org.apache.qpid.client.AMQDestination;
import org.apache.qpid.client.AMQSession;
import org.apache.qpid.client.Closeable;
import org.apache.qpid.client.message.AbstractJMSMessage;
import org.apache.qpid.client.message.JMSBytesMessage;
import org.apache.qpid.client.protocol.AMQProtocolHandler;
import org.apache.qpid.framing.AMQDataBlock;
import org.apache.qpid.framing.AMQFrame;
import org.apache.qpid.framing.BasicContentHeaderProperties;
import org.apache.qpid.framing.BasicPublishBody;
import org.apache.qpid.framing.CompositeAMQDataBlock;
import org.apache.qpid.framing.ContentBody;
import org.apache.qpid.framing.ContentHeaderBody;
import org.apache.qpid.framing.ExchangeDeclareBody;
import org.apache.qpid.jms.MessageProducer;

public class BasicMessageProducer
extends Closeable
implements MessageProducer {
    protected final Logger _logger = Logger.getLogger(this.getClass());
    private AMQConnection _connection;
    private boolean _disableTimestamps;
    private int _messagePriority;
    private long _timeToLive;
    private int _deliveryMode = 2;
    protected AMQDestination _destination;
    private String _encoding;
    private String _mimeType;
    private AMQProtocolHandler _protocolHandler;
    private boolean _transacted;
    private int _channelId;
    private long _producerId;
    private AMQSession _session;
    private final boolean _immediate;
    private final boolean _mandatory;
    private final boolean _waitUntilSent;

    protected BasicMessageProducer(AMQConnection connection, AMQDestination destination, boolean transacted, int channelId, AMQSession session, AMQProtocolHandler protocolHandler, long producerId, boolean immediate, boolean mandatory, boolean waitUntilSent) {
        this._connection = connection;
        this._destination = destination;
        this._transacted = transacted;
        this._protocolHandler = protocolHandler;
        this._channelId = channelId;
        this._session = session;
        this._producerId = producerId;
        if (destination != null) {
            this.declareDestination(destination);
        }
        this._immediate = immediate;
        this._mandatory = mandatory;
        this._waitUntilSent = waitUntilSent;
    }

    void resubscribe() throws AMQException {
        if (this._destination != null) {
            this.declareDestination(this._destination);
        }
    }

    private void declareDestination(AMQDestination destination) {
        AMQFrame declare = ExchangeDeclareBody.createAMQFrame((int)this._channelId, (int)0, (String)destination.getExchangeName(), (String)destination.getExchangeClass(), (boolean)false, (boolean)false, (boolean)false, (boolean)false, (boolean)true, null);
        this._protocolHandler.writeFrame((AMQDataBlock)declare);
    }

    public void setDisableMessageID(boolean b) throws JMSException {
        this.checkNotClosed();
    }

    public boolean getDisableMessageID() throws JMSException {
        this.checkNotClosed();
        return false;
    }

    public void setDisableMessageTimestamp(boolean b) throws JMSException {
        this.checkNotClosed();
        this._disableTimestamps = b;
    }

    public boolean getDisableMessageTimestamp() throws JMSException {
        this.checkNotClosed();
        return this._disableTimestamps;
    }

    public void setDeliveryMode(int i) throws JMSException {
        this.checkNotClosed();
        if (i != 1 && i != 2) {
            throw new JMSException("DeliveryMode must be either NON_PERSISTENT or PERSISTENT. Value of " + i + " is illegal");
        }
        this._deliveryMode = i;
    }

    public int getDeliveryMode() throws JMSException {
        this.checkNotClosed();
        return this._deliveryMode;
    }

    public void setPriority(int i) throws JMSException {
        this.checkNotClosed();
        if (i < 0 || i > 9) {
            throw new IllegalArgumentException("Priority of " + i + " is illegal. Value must be in range 0 to 9");
        }
        this._messagePriority = i;
    }

    public int getPriority() throws JMSException {
        this.checkNotClosed();
        return this._messagePriority;
    }

    public void setTimeToLive(long l) throws JMSException {
        this.checkNotClosed();
        if (l < 0L) {
            throw new IllegalArgumentException("Time to live must be non-negative - supplied value was " + l);
        }
        this._timeToLive = l;
    }

    public long getTimeToLive() throws JMSException {
        this.checkNotClosed();
        return this._timeToLive;
    }

    public Destination getDestination() throws JMSException {
        this.checkNotClosed();
        return this._destination;
    }

    public void close() throws JMSException {
        this._closed.set(true);
        this._session.deregisterProducer(this._producerId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void send(Message message) throws JMSException {
        Object object = this._connection.getFailoverMutex();
        synchronized (object) {
            this.sendImpl(this._destination, (AbstractJMSMessage)message, this._deliveryMode, this._messagePriority, this._timeToLive, this._mandatory, this._immediate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void send(Message message, int deliveryMode) throws JMSException {
        Object object = this._connection.getFailoverMutex();
        synchronized (object) {
            this.sendImpl(this._destination, (AbstractJMSMessage)message, deliveryMode, this._messagePriority, this._timeToLive, this._mandatory, this._immediate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void send(Message message, int deliveryMode, boolean immediate) throws JMSException {
        Object object = this._connection.getFailoverMutex();
        synchronized (object) {
            this.sendImpl(this._destination, (AbstractJMSMessage)message, deliveryMode, this._messagePriority, this._timeToLive, this._mandatory, immediate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void send(Message message, int deliveryMode, int priority, long timeToLive) throws JMSException {
        Object object = this._connection.getFailoverMutex();
        synchronized (object) {
            this.sendImpl(this._destination, (AbstractJMSMessage)message, deliveryMode, priority, timeToLive, this._mandatory, this._immediate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void send(Destination destination, Message message) throws JMSException {
        this.checkNotClosed();
        Object object = this._connection.getFailoverMutex();
        synchronized (object) {
            this.validateDestination(destination);
            this.sendImpl((AMQDestination)destination, (AbstractJMSMessage)message, this._deliveryMode, this._messagePriority, this._timeToLive, this._mandatory, this._immediate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void send(Destination destination, Message message, int deliveryMode, int priority, long timeToLive) throws JMSException {
        this.checkNotClosed();
        Object object = this._connection.getFailoverMutex();
        synchronized (object) {
            this.validateDestination(destination);
            this.sendImpl((AMQDestination)destination, (AbstractJMSMessage)message, deliveryMode, priority, timeToLive, this._mandatory, this._immediate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void send(Destination destination, Message message, int deliveryMode, int priority, long timeToLive, boolean mandatory) throws JMSException {
        this.checkNotClosed();
        Object object = this._connection.getFailoverMutex();
        synchronized (object) {
            this.validateDestination(destination);
            this.sendImpl((AMQDestination)destination, (AbstractJMSMessage)message, deliveryMode, priority, timeToLive, mandatory, this._immediate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void send(Destination destination, Message message, int deliveryMode, int priority, long timeToLive, boolean mandatory, boolean immediate) throws JMSException {
        this.checkNotClosed();
        Object object = this._connection.getFailoverMutex();
        synchronized (object) {
            this.validateDestination(destination);
            this.sendImpl((AMQDestination)destination, (AbstractJMSMessage)message, deliveryMode, priority, timeToLive, mandatory, immediate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void send(Destination destination, Message message, int deliveryMode, int priority, long timeToLive, boolean mandatory, boolean immediate, boolean waitUntilSent) throws JMSException {
        this.checkNotClosed();
        Object object = this._connection.getFailoverMutex();
        synchronized (object) {
            this.validateDestination(destination);
            this.sendImpl((AMQDestination)destination, (AbstractJMSMessage)message, deliveryMode, priority, timeToLive, mandatory, immediate, waitUntilSent);
        }
    }

    private void validateDestination(Destination destination) throws JMSException {
        if (!(destination instanceof AMQDestination)) {
            throw new JMSException("Unsupported destination class: " + (destination != null ? destination.getClass() : null));
        }
        this.declareDestination((AMQDestination)destination);
    }

    protected void sendImpl(AMQDestination destination, AbstractJMSMessage message, int deliveryMode, int priority, long timeToLive, boolean mandatory, boolean immediate) throws JMSException {
        this.sendImpl(destination, message, deliveryMode, priority, timeToLive, mandatory, immediate, this._waitUntilSent);
    }

    protected void sendImpl(AMQDestination destination, AbstractJMSMessage message, int deliveryMode, int priority, long timeToLive, boolean mandatory, boolean immediate, boolean wait) throws JMSException {
        JMSBytesMessage msg;
        AMQFrame publishFrame = BasicPublishBody.createAMQFrame((int)this._channelId, (int)0, (String)destination.getExchangeName(), (String)destination.getRoutingKey(), (boolean)mandatory, (boolean)immediate);
        long currentTime = 0L;
        if (!this._disableTimestamps) {
            currentTime = System.currentTimeMillis();
            message.setJMSTimestamp(currentTime);
        }
        if (message instanceof JMSBytesMessage && !(msg = (JMSBytesMessage)message).isReadable()) {
            msg.reset();
        }
        ByteBuffer payload = message.getData();
        BasicContentHeaderProperties contentHeaderProperties = message.getJmsContentHeaderProperties();
        if (timeToLive > 0L) {
            if (!this._disableTimestamps) {
                contentHeaderProperties.setExpiration(currentTime + timeToLive);
            }
        } else if (!this._disableTimestamps) {
            contentHeaderProperties.setExpiration(0L);
        }
        contentHeaderProperties.setDeliveryMode((byte)deliveryMode);
        contentHeaderProperties.setPriority((byte)priority);
        int size = payload.limit();
        ContentBody[] contentBodies = this.createContentBodies(payload);
        AMQFrame[] frames = new AMQFrame[2 + contentBodies.length];
        for (int i = 0; i < contentBodies.length; ++i) {
            frames[2 + i] = ContentBody.createAMQFrame((int)this._channelId, (ContentBody)contentBodies[i]);
        }
        if (contentBodies.length > 0 && this._logger.isDebugEnabled()) {
            this._logger.debug((Object)("Sending content body frames to " + destination));
        }
        AMQFrame contentHeaderFrame = ContentHeaderBody.createAMQFrame((int)this._channelId, (int)60, (int)0, (BasicContentHeaderProperties)contentHeaderProperties, (long)size);
        if (this._logger.isDebugEnabled()) {
            this._logger.debug((Object)("Sending content header frame to " + destination));
        }
        frames[0] = publishFrame;
        frames[1] = contentHeaderFrame;
        CompositeAMQDataBlock compositeFrame = new CompositeAMQDataBlock((AMQDataBlock[])frames);
        this._protocolHandler.writeFrame((AMQDataBlock)compositeFrame, wait);
    }

    private ContentBody[] createContentBodies(ByteBuffer payload) {
        long framePayloadMax;
        if (payload == null) {
            return null;
        }
        if (payload.remaining() == 0) {
            return new ContentBody[0];
        }
        int dataLength = payload.remaining();
        int lastFrame = (long)dataLength % (framePayloadMax = this._session.getAMQConnection().getMaximumFrameSize() - 1L) > 0L ? 1 : 0;
        int frameCount = (int)((long)dataLength / framePayloadMax) + lastFrame;
        ContentBody[] bodies = new ContentBody[frameCount];
        if (frameCount == 1) {
            bodies[0] = new ContentBody();
            bodies[0].payload = payload;
        } else {
            long remaining = dataLength;
            for (int i = 0; i < bodies.length; ++i) {
                bodies[i] = new ContentBody();
                payload.position((int)framePayloadMax * i);
                int length = remaining >= framePayloadMax ? (int)framePayloadMax : (int)remaining;
                payload.limit(payload.position() + length);
                bodies[i].payload = payload.slice();
                remaining -= (long)length;
            }
        }
        return bodies;
    }

    public void setMimeType(String mimeType) throws JMSException {
        this.checkNotClosed();
        this._mimeType = mimeType;
    }

    public void setEncoding(String encoding) throws JMSException, UnsupportedEncodingException {
        this.checkNotClosed();
        this._encoding = encoding;
    }
}

