/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.client;

import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.Topic;
import javax.jms.TopicSubscriber;
import org.apache.qpid.client.BasicMessageConsumer;

class TopicSubscriberAdaptor
implements TopicSubscriber {
    private final Topic _topic;
    private final MessageConsumer _consumer;
    private final boolean _noLocal;

    TopicSubscriberAdaptor(Topic topic, MessageConsumer consumer, boolean noLocal) {
        this._topic = topic;
        this._consumer = consumer;
        this._noLocal = noLocal;
    }

    TopicSubscriberAdaptor(Topic topic, BasicMessageConsumer consumer) {
        this(topic, consumer, consumer.isNoLocal());
    }

    public Topic getTopic() throws JMSException {
        return this._topic;
    }

    public boolean getNoLocal() throws JMSException {
        return this._noLocal;
    }

    public String getMessageSelector() throws JMSException {
        return this._consumer.getMessageSelector();
    }

    public MessageListener getMessageListener() throws JMSException {
        return this._consumer.getMessageListener();
    }

    public void setMessageListener(MessageListener messageListener) throws JMSException {
        this._consumer.setMessageListener(messageListener);
    }

    public Message receive() throws JMSException {
        return this._consumer.receive();
    }

    public Message receive(long l) throws JMSException {
        return this._consumer.receive(l);
    }

    public Message receiveNoWait() throws JMSException {
        return this._consumer.receiveNoWait();
    }

    public void close() throws JMSException {
        this._consumer.close();
    }
}

