/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.client.failover;

import java.util.concurrent.CountDownLatch;
import org.apache.log4j.Logger;
import org.apache.mina.common.IoSession;
import org.apache.qpid.AMQDisconnectedException;
import org.apache.qpid.client.failover.FailoverException;
import org.apache.qpid.client.failover.FailoverState;
import org.apache.qpid.client.protocol.AMQProtocolHandler;
import org.apache.qpid.client.state.AMQStateManager;

public class FailoverHandler
implements Runnable {
    private static final Logger _logger = Logger.getLogger(FailoverHandler.class);
    private final IoSession _session;
    private AMQProtocolHandler _amqProtocolHandler;
    private String _host;
    private int _port;

    public FailoverHandler(AMQProtocolHandler amqProtocolHandler, IoSession session) {
        this._amqProtocolHandler = amqProtocolHandler;
        this._session = session;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        if (Thread.currentThread().isDaemon()) {
            throw new IllegalStateException("FailoverHandler must run on a non-daemon thread.");
        }
        this._amqProtocolHandler.setFailoverLatch(new CountDownLatch(1));
        this._amqProtocolHandler.propagateExceptionToWaiters(new FailoverException("Failing over about to start"));
        Object object = this._amqProtocolHandler.getConnection().getFailoverMutex();
        synchronized (object) {
            _logger.info((Object)"Starting failover process");
            AMQStateManager existingStateManager = this._amqProtocolHandler.getStateManager();
            this._amqProtocolHandler.setStateManager(new AMQStateManager());
            if (!this._amqProtocolHandler.getConnection().firePreFailover(this._host != null)) {
                this._amqProtocolHandler.setStateManager(existingStateManager);
                if (this._host != null) {
                    this._amqProtocolHandler.getConnection().exceptionReceived((Throwable)new AMQDisconnectedException("Redirect was vetoed by client"));
                } else {
                    this._amqProtocolHandler.getConnection().exceptionReceived((Throwable)new AMQDisconnectedException("Failover was vetoed by client"));
                }
                this._amqProtocolHandler.getFailoverLatch().countDown();
                this._amqProtocolHandler.setFailoverLatch(null);
                return;
            }
            boolean failoverSucceeded = this._host != null ? this._amqProtocolHandler.getConnection().attemptReconnection(this._host, this._port, this._amqProtocolHandler.isUseSSL()) : this._amqProtocolHandler.getConnection().attemptReconnection();
            if (!failoverSucceeded) {
                this._amqProtocolHandler.setStateManager(existingStateManager);
                this._amqProtocolHandler.getConnection().exceptionReceived((Throwable)new AMQDisconnectedException("Server closed connection and no failover was successful"));
            } else {
                this._amqProtocolHandler.setStateManager(existingStateManager);
                try {
                    if (this._amqProtocolHandler.getConnection().firePreResubscribe()) {
                        _logger.info((Object)"Resubscribing on new connection");
                        this._amqProtocolHandler.getConnection().resubscribeSessions();
                    } else {
                        _logger.info((Object)"Client vetoed automatic resubscription");
                    }
                    this._amqProtocolHandler.getConnection().fireFailoverComplete();
                    this._amqProtocolHandler.setFailoverState(FailoverState.NOT_STARTED);
                    _logger.info((Object)"Connection failover completed successfully");
                }
                catch (Exception e) {
                    _logger.info((Object)"Failover process failed - exception being propagated by protocol handler");
                    this._amqProtocolHandler.setFailoverState(FailoverState.FAILED);
                    try {
                        this._amqProtocolHandler.exceptionCaught(this._session, e);
                    }
                    catch (Exception ex) {
                        _logger.error((Object)("Error notifying protocol session of error: " + ex), (Throwable)ex);
                    }
                }
            }
        }
        this._amqProtocolHandler.getFailoverLatch().countDown();
    }

    public String getHost() {
        return this._host;
    }

    public void setHost(String host) {
        this._host = host;
    }

    public int getPort() {
        return this._port;
    }

    public void setPort(int port) {
        this._port = port;
    }
}

