/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.client.failover;

import javax.jms.JMSException;
import org.apache.log4j.Logger;
import org.apache.qpid.client.AMQConnection;
import org.apache.qpid.client.failover.FailoverException;

public abstract class FailoverSupport {
    private static final Logger _log = Logger.getLogger(FailoverSupport.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object execute(AMQConnection con) throws JMSException {
        while (true) {
            try {
                con.blockUntilNotFailingOver();
            }
            catch (InterruptedException e) {
                _log.info((Object)("Interrupted: " + e), (Throwable)e);
                return null;
            }
            Object object = con.getFailoverMutex();
            synchronized (object) {
                try {
                    return this.operation();
                }
                catch (FailoverException e) {
                    _log.info((Object)"Failover exception caught during operation");
                }
            }
        }
    }

    protected abstract Object operation() throws JMSException;
}

