/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.client.handler;

import org.apache.log4j.Logger;
import org.apache.qpid.AMQChannelClosedException;
import org.apache.qpid.AMQException;
import org.apache.qpid.client.AMQNoConsumersException;
import org.apache.qpid.client.AMQNoRouteException;
import org.apache.qpid.client.protocol.AMQMethodEvent;
import org.apache.qpid.client.state.AMQStateManager;
import org.apache.qpid.client.state.StateAwareMethodListener;
import org.apache.qpid.framing.AMQDataBlock;
import org.apache.qpid.framing.AMQFrame;
import org.apache.qpid.framing.ChannelCloseBody;
import org.apache.qpid.framing.ChannelCloseOkBody;
import org.apache.qpid.protocol.AMQConstant;

public class ChannelCloseMethodHandler
implements StateAwareMethodListener {
    private static final Logger _logger = Logger.getLogger(ChannelCloseMethodHandler.class);
    private static ChannelCloseMethodHandler _handler = new ChannelCloseMethodHandler();

    public static ChannelCloseMethodHandler getInstance() {
        return _handler;
    }

    public void methodReceived(AMQStateManager stateManager, AMQMethodEvent evt) throws AMQException {
        _logger.debug((Object)"ChannelClose method received");
        ChannelCloseBody method = (ChannelCloseBody)evt.getMethod();
        int errorCode = method.replyCode;
        String reason = method.replyText;
        if (_logger.isDebugEnabled()) {
            _logger.debug((Object)("Channel close reply code: " + errorCode + ", reason: " + reason));
        }
        AMQFrame frame = ChannelCloseOkBody.createAMQFrame((int)evt.getChannelId());
        evt.getProtocolSession().writeFrame((AMQDataBlock)frame);
        if (errorCode != AMQConstant.REPLY_SUCCESS.getCode()) {
            _logger.error((Object)("Channel close received with errorCode " + errorCode + ", and reason " + reason));
            if (errorCode == AMQConstant.NO_CONSUMERS.getCode()) {
                throw new AMQNoConsumersException("Error: " + reason, null);
            }
            if (errorCode == AMQConstant.NO_ROUTE.getCode()) {
                throw new AMQNoRouteException("Error: " + reason, null);
            }
            throw new AMQChannelClosedException(errorCode, "Error: " + reason);
        }
        evt.getProtocolSession().channelClosed(evt.getChannelId(), errorCode, reason);
    }
}

