/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.client.handler;

import org.apache.log4j.Logger;
import org.apache.qpid.AMQConnectionClosedException;
import org.apache.qpid.AMQException;
import org.apache.qpid.client.AMQAuthenticationException;
import org.apache.qpid.client.protocol.AMQMethodEvent;
import org.apache.qpid.client.state.AMQState;
import org.apache.qpid.client.state.AMQStateManager;
import org.apache.qpid.client.state.StateAwareMethodListener;
import org.apache.qpid.framing.AMQDataBlock;
import org.apache.qpid.framing.ConnectionCloseBody;
import org.apache.qpid.framing.ConnectionCloseOkBody;
import org.apache.qpid.protocol.AMQConstant;

public class ConnectionCloseMethodHandler
implements StateAwareMethodListener {
    private static final Logger _logger = Logger.getLogger(ConnectionCloseMethodHandler.class);
    private static ConnectionCloseMethodHandler _handler = new ConnectionCloseMethodHandler();

    public static ConnectionCloseMethodHandler getInstance() {
        return _handler;
    }

    private ConnectionCloseMethodHandler() {
    }

    public void methodReceived(AMQStateManager stateManager, AMQMethodEvent evt) throws AMQException {
        _logger.info((Object)"ConnectionClose frame received");
        ConnectionCloseBody method = (ConnectionCloseBody)evt.getMethod();
        int errorCode = method.replyCode;
        String reason = method.replyText;
        evt.getProtocolSession().writeFrame((AMQDataBlock)ConnectionCloseOkBody.createAMQFrame((int)0));
        if (errorCode != 200) {
            if (errorCode == AMQConstant.NOT_ALLOWED.getCode()) {
                _logger.info((Object)("Authentication Error:" + Thread.currentThread().getName()));
                evt.getProtocolSession().closeProtocolSession();
                stateManager.changeState(AMQState.CONNECTION_NOT_STARTED);
                throw new AMQAuthenticationException(errorCode, reason);
            }
            _logger.info((Object)("Connection close received with error code " + errorCode));
            throw new AMQConnectionClosedException(errorCode, "Error: " + reason);
        }
        evt.getProtocolSession().closeProtocolSession();
        stateManager.changeState(AMQState.CONNECTION_CLOSED);
    }
}

