/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.client.handler;

import org.apache.log4j.Logger;
import org.apache.qpid.AMQException;
import org.apache.qpid.client.protocol.AMQMethodEvent;
import org.apache.qpid.client.state.AMQStateManager;
import org.apache.qpid.client.state.StateAwareMethodListener;
import org.apache.qpid.framing.ConnectionRedirectBody;

public class ConnectionRedirectMethodHandler
implements StateAwareMethodListener {
    private static final Logger _logger = Logger.getLogger(ConnectionRedirectMethodHandler.class);
    private static final int DEFAULT_REDIRECT_PORT = 5672;
    private static ConnectionRedirectMethodHandler _handler = new ConnectionRedirectMethodHandler();

    public static ConnectionRedirectMethodHandler getInstance() {
        return _handler;
    }

    private ConnectionRedirectMethodHandler() {
    }

    public void methodReceived(AMQStateManager stateManager, AMQMethodEvent evt) throws AMQException {
        int port;
        String host;
        _logger.info((Object)"ConnectionRedirect frame received");
        ConnectionRedirectBody method = (ConnectionRedirectBody)evt.getMethod();
        int portIndex = method.host.indexOf(58);
        if (portIndex == -1) {
            host = method.host;
            port = 5672;
        } else {
            host = method.host.substring(0, portIndex);
            port = Integer.parseInt(method.host.substring(portIndex + 1));
        }
        evt.getProtocolSession().failover(host, port);
    }
}

