/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.client.handler;

import javax.security.sasl.SaslClient;
import javax.security.sasl.SaslException;
import org.apache.qpid.AMQException;
import org.apache.qpid.client.protocol.AMQMethodEvent;
import org.apache.qpid.client.state.AMQStateManager;
import org.apache.qpid.client.state.StateAwareMethodListener;
import org.apache.qpid.framing.AMQDataBlock;
import org.apache.qpid.framing.AMQFrame;
import org.apache.qpid.framing.ConnectionSecureBody;
import org.apache.qpid.framing.ConnectionSecureOkBody;

public class ConnectionSecureMethodHandler
implements StateAwareMethodListener {
    private static final ConnectionSecureMethodHandler _instance = new ConnectionSecureMethodHandler();

    public static ConnectionSecureMethodHandler getInstance() {
        return _instance;
    }

    public void methodReceived(AMQStateManager stateManager, AMQMethodEvent evt) throws AMQException {
        SaslClient client = evt.getProtocolSession().getSaslClient();
        if (client == null) {
            throw new AMQException("No SASL client set up - cannot proceed with authentication");
        }
        ConnectionSecureBody body = (ConnectionSecureBody)evt.getMethod();
        try {
            byte[] response = client.evaluateChallenge(body.challenge);
            AMQFrame responseFrame = ConnectionSecureOkBody.createAMQFrame((int)evt.getChannelId(), (byte[])response);
            evt.getProtocolSession().writeFrame((AMQDataBlock)responseFrame);
        }
        catch (SaslException e) {
            throw new AMQException("Error processing SASL challenge: " + e, (Throwable)e);
        }
    }
}

