/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.client.handler;

import java.io.UnsupportedEncodingException;
import java.util.HashSet;
import java.util.StringTokenizer;
import javax.security.sasl.Sasl;
import javax.security.sasl.SaslClient;
import javax.security.sasl.SaslException;
import org.apache.log4j.Logger;
import org.apache.qpid.AMQException;
import org.apache.qpid.client.protocol.AMQMethodEvent;
import org.apache.qpid.client.protocol.AMQProtocolSession;
import org.apache.qpid.client.security.AMQCallbackHandler;
import org.apache.qpid.client.security.CallbackHandlerRegistry;
import org.apache.qpid.client.state.AMQState;
import org.apache.qpid.client.state.AMQStateManager;
import org.apache.qpid.client.state.StateAwareMethodListener;
import org.apache.qpid.framing.AMQDataBlock;
import org.apache.qpid.framing.ConnectionStartBody;
import org.apache.qpid.framing.ConnectionStartOkBody;
import org.apache.qpid.framing.FieldTable;

public class ConnectionStartMethodHandler
implements StateAwareMethodListener {
    private static final Logger _log = Logger.getLogger(ConnectionStartMethodHandler.class);
    private static final ConnectionStartMethodHandler _instance = new ConnectionStartMethodHandler();

    public static ConnectionStartMethodHandler getInstance() {
        return _instance;
    }

    private ConnectionStartMethodHandler() {
    }

    public void methodReceived(AMQStateManager stateManager, AMQMethodEvent evt) throws AMQException {
        ConnectionStartBody body = (ConnectionStartBody)evt.getMethod();
        try {
            byte[] saslResponse;
            if (body.mechanisms == null) {
                throw new AMQException("mechanism not specified in ConnectionStart method frame");
            }
            String mechanism = this.chooseMechanism(body.mechanisms);
            if (mechanism == null) {
                throw new AMQException("No supported security mechanism found, passed: " + new String(body.mechanisms));
            }
            AMQProtocolSession ps = evt.getProtocolSession();
            try {
                SaslClient sc = Sasl.createSaslClient(new String[]{mechanism}, null, "AMQP", "localhost", null, this.createCallbackHandler(mechanism, ps));
                if (sc == null) {
                    throw new AMQException("Client SASL configuration error: no SaslClient could be created for mechanism " + mechanism + ". Please ensure all factories are registered. See DynamicSaslRegistrar for " + " details of how to register non-standard SASL client providers.");
                }
                ps.setSaslClient(sc);
                saslResponse = sc.hasInitialResponse() ? sc.evaluateChallenge(new byte[0]) : null;
            }
            catch (SaslException e) {
                ps.setSaslClient(null);
                throw new AMQException("Unable to create SASL client: " + e, (Throwable)e);
            }
            if (body.locales == null) {
                throw new AMQException("Locales is not defined in Connection Start method");
            }
            String locales = new String(body.locales, "utf8");
            StringTokenizer tokenizer = new StringTokenizer(locales, " ");
            String selectedLocale = null;
            if (!tokenizer.hasMoreTokens()) {
                throw new AMQException("No locales sent from server, passed: " + locales);
            }
            selectedLocale = tokenizer.nextToken();
            stateManager.changeState(AMQState.CONNECTION_NOT_TUNED);
            FieldTable clientProperties = new FieldTable();
            clientProperties.put((Object)"instance", (Object)ps.getClientID());
            clientProperties.put((Object)"product", (Object)"Qpid");
            clientProperties.put((Object)"version", (Object)"1.0");
            clientProperties.put((Object)"platform", (Object)this.getFullSystemInfo());
            ps.writeFrame((AMQDataBlock)ConnectionStartOkBody.createAMQFrame((int)evt.getChannelId(), (FieldTable)clientProperties, (String)mechanism, (byte[])saslResponse, (String)selectedLocale));
        }
        catch (UnsupportedEncodingException e) {
            throw new AMQException(_log, "Unable to decode data: " + e, (Throwable)e);
        }
    }

    private String getFullSystemInfo() {
        StringBuffer fullSystemInfo = new StringBuffer();
        fullSystemInfo.append(System.getProperty("java.runtime.name"));
        fullSystemInfo.append(", " + System.getProperty("java.runtime.version"));
        fullSystemInfo.append(", " + System.getProperty("java.vendor"));
        fullSystemInfo.append(", " + System.getProperty("os.arch"));
        fullSystemInfo.append(", " + System.getProperty("os.name"));
        fullSystemInfo.append(", " + System.getProperty("os.version"));
        fullSystemInfo.append(", " + System.getProperty("sun.os.patch.level"));
        return fullSystemInfo.toString();
    }

    private String chooseMechanism(byte[] availableMechanisms) throws UnsupportedEncodingException {
        String mechanisms = new String(availableMechanisms, "utf8");
        StringTokenizer tokenizer = new StringTokenizer(mechanisms, " ");
        HashSet<String> mechanismSet = new HashSet<String>();
        while (tokenizer.hasMoreTokens()) {
            mechanismSet.add(tokenizer.nextToken());
        }
        String preferredMechanisms = CallbackHandlerRegistry.getInstance().getMechanisms();
        StringTokenizer prefTokenizer = new StringTokenizer(preferredMechanisms, " ");
        while (prefTokenizer.hasMoreTokens()) {
            String mech = prefTokenizer.nextToken();
            if (!mechanismSet.contains(mech)) continue;
            return mech;
        }
        return null;
    }

    private AMQCallbackHandler createCallbackHandler(String mechanism, AMQProtocolSession protocolSession) throws AMQException {
        Class mechanismClass = CallbackHandlerRegistry.getInstance().getCallbackHandlerClass(mechanism);
        try {
            Object instance = mechanismClass.newInstance();
            AMQCallbackHandler cbh = (AMQCallbackHandler)instance;
            cbh.initialise(protocolSession);
            return cbh;
        }
        catch (Exception e) {
            throw new AMQException("Unable to create callback handler: " + e, (Throwable)e);
        }
    }
}

