/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.client.handler;

import org.apache.log4j.Logger;
import org.apache.qpid.AMQException;
import org.apache.qpid.client.ConnectionTuneParameters;
import org.apache.qpid.client.protocol.AMQMethodEvent;
import org.apache.qpid.client.protocol.AMQProtocolSession;
import org.apache.qpid.client.state.AMQState;
import org.apache.qpid.client.state.AMQStateManager;
import org.apache.qpid.client.state.StateAwareMethodListener;
import org.apache.qpid.framing.AMQDataBlock;
import org.apache.qpid.framing.AMQFrame;
import org.apache.qpid.framing.ConnectionOpenBody;
import org.apache.qpid.framing.ConnectionTuneBody;
import org.apache.qpid.framing.ConnectionTuneOkBody;

public class ConnectionTuneMethodHandler
implements StateAwareMethodListener {
    private static final Logger _logger = Logger.getLogger(ConnectionTuneMethodHandler.class);
    private static final ConnectionTuneMethodHandler _instance = new ConnectionTuneMethodHandler();

    public static ConnectionTuneMethodHandler getInstance() {
        return _instance;
    }

    protected ConnectionTuneMethodHandler() {
    }

    public void methodReceived(AMQStateManager stateManager, AMQMethodEvent evt) throws AMQException {
        _logger.debug((Object)"ConnectionTune frame received");
        ConnectionTuneBody frame = (ConnectionTuneBody)evt.getMethod();
        AMQProtocolSession session = evt.getProtocolSession();
        ConnectionTuneParameters params = session.getConnectionTuneParameters();
        if (params == null) {
            params = new ConnectionTuneParameters();
        }
        params.setFrameMax(frame.frameMax);
        params.setChannelMax(frame.channelMax);
        params.setHeartbeat(Integer.getInteger("amqj.heartbeat.delay", frame.heartbeat));
        session.setConnectionTuneParameters(params);
        stateManager.changeState(AMQState.CONNECTION_NOT_OPENED);
        session.writeFrame((AMQDataBlock)this.createTuneOkFrame(evt.getChannelId(), params));
        session.writeFrame((AMQDataBlock)this.createConnectionOpenFrame(evt.getChannelId(), session.getAMQConnection().getVirtualHost(), null, true));
    }

    protected AMQFrame createConnectionOpenFrame(int channel, String path, String capabilities, boolean insist) {
        return ConnectionOpenBody.createAMQFrame((int)channel, (String)path, (String)capabilities, (boolean)insist);
    }

    protected AMQFrame createTuneOkFrame(int channel, ConnectionTuneParameters params) {
        return ConnectionTuneOkBody.createAMQFrame((int)channel, (int)params.getChannelMax(), (long)params.getFrameMax(), (int)params.getHeartbeat());
    }
}

