/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.client.message;

import java.util.Collections;
import java.util.Enumeration;
import java.util.Map;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import org.apache.commons.collections.map.ReferenceMap;
import org.apache.mina.common.ByteBuffer;
import org.apache.qpid.AMQException;
import org.apache.qpid.client.AMQDestination;
import org.apache.qpid.client.AMQQueue;
import org.apache.qpid.client.AMQTopic;
import org.apache.qpid.client.JmsNotImplementedException;
import org.apache.qpid.client.message.AMQMessage;
import org.apache.qpid.framing.BasicContentHeaderProperties;
import org.apache.qpid.framing.ContentHeaderProperties;
import org.apache.qpid.framing.FieldTable;
import org.apache.qpid.framing.FieldTableKeyEnumeration;

public abstract class AbstractJMSMessage
extends AMQMessage
implements Message {
    private static final Map _destinationCache = Collections.synchronizedMap(new ReferenceMap());
    public static final char BOOLEAN_PROPERTY_PREFIX = 'B';
    public static final char BYTE_PROPERTY_PREFIX = 'b';
    public static final char SHORT_PROPERTY_PREFIX = 's';
    public static final char INT_PROPERTY_PREFIX = 'i';
    public static final char LONG_PROPERTY_PREFIX = 'l';
    public static final char FLOAT_PROPERTY_PREFIX = 'f';
    public static final char DOUBLE_PROPERTY_PREFIX = 'd';
    public static final char STRING_PROPERTY_PREFIX = 'S';
    protected boolean _redelivered;
    protected ByteBuffer _data;

    protected AbstractJMSMessage(ByteBuffer data) {
        super((ContentHeaderProperties)new BasicContentHeaderProperties());
        this._data = data;
        if (this._data != null) {
            this._data.acquire();
        }
    }

    protected AbstractJMSMessage(long deliveryTag, BasicContentHeaderProperties contentHeader, ByteBuffer data) throws AMQException {
        this(contentHeader, deliveryTag);
        this._data = data;
        if (this._data != null) {
            this._data.acquire();
        }
    }

    protected AbstractJMSMessage(BasicContentHeaderProperties contentHeader, long deliveryTag) {
        super((ContentHeaderProperties)contentHeader, deliveryTag);
    }

    public String getJMSMessageID() throws JMSException {
        if (this.getJmsContentHeaderProperties().getMessageId() == null) {
            this.getJmsContentHeaderProperties().setMessageId("ID:" + this._deliveryTag);
        }
        return this.getJmsContentHeaderProperties().getMessageId();
    }

    public void setJMSMessageID(String messageId) throws JMSException {
        this.getJmsContentHeaderProperties().setMessageId(messageId);
    }

    public long getJMSTimestamp() throws JMSException {
        return new Long(this.getJmsContentHeaderProperties().getTimestamp());
    }

    public void setJMSTimestamp(long timestamp) throws JMSException {
        this.getJmsContentHeaderProperties().setTimestamp(timestamp);
    }

    public byte[] getJMSCorrelationIDAsBytes() throws JMSException {
        return this.getJmsContentHeaderProperties().getCorrelationId().getBytes();
    }

    public void setJMSCorrelationIDAsBytes(byte[] bytes) throws JMSException {
        this.getJmsContentHeaderProperties().setCorrelationId(new String(bytes));
    }

    public void setJMSCorrelationID(String correlationId) throws JMSException {
        this.getJmsContentHeaderProperties().setCorrelationId(correlationId);
    }

    public String getJMSCorrelationID() throws JMSException {
        return this.getJmsContentHeaderProperties().getCorrelationId();
    }

    public Destination getJMSReplyTo() throws JMSException {
        String replyToEncoding = this.getJmsContentHeaderProperties().getReplyTo();
        if (replyToEncoding == null) {
            return null;
        }
        Destination dest = (Destination)_destinationCache.get(replyToEncoding);
        if (dest == null) {
            char destType = replyToEncoding.charAt(0);
            if (destType == 'Q') {
                dest = new AMQQueue(replyToEncoding.substring(1));
            } else if (destType == 'T') {
                dest = new AMQTopic(replyToEncoding.substring(1));
            } else {
                throw new JMSException("Illegal value in JMS_ReplyTo property: " + replyToEncoding);
            }
            _destinationCache.put(replyToEncoding, dest);
        }
        return dest;
    }

    public void setJMSReplyTo(Destination destination) throws JMSException {
        if (destination == null) {
            throw new IllegalArgumentException("Null destination not allowed");
        }
        if (!(destination instanceof AMQDestination)) {
            throw new IllegalArgumentException("ReplyTo destination my be an AMQ destination - passed argument was type " + destination.getClass());
        }
        AMQDestination amqd = (AMQDestination)destination;
        String encodedDestination = amqd.getEncodedName();
        _destinationCache.put(encodedDestination, destination);
        this.getJmsContentHeaderProperties().setReplyTo(encodedDestination);
    }

    public Destination getJMSDestination() throws JMSException {
        throw new JmsNotImplementedException();
    }

    public void setJMSDestination(Destination destination) throws JMSException {
        throw new JmsNotImplementedException();
    }

    public int getJMSDeliveryMode() throws JMSException {
        return this.getJmsContentHeaderProperties().getDeliveryMode();
    }

    public void setJMSDeliveryMode(int i) throws JMSException {
        this.getJmsContentHeaderProperties().setDeliveryMode((byte)i);
    }

    public boolean getJMSRedelivered() throws JMSException {
        return this._redelivered;
    }

    public void setJMSRedelivered(boolean b) throws JMSException {
        this._redelivered = b;
    }

    public String getJMSType() throws JMSException {
        return this.getMimeType();
    }

    public void setJMSType(String string) throws JMSException {
        throw new JMSException("Cannot set JMS Type - it is implicitly defined based on message type");
    }

    public long getJMSExpiration() throws JMSException {
        return new Long(this.getJmsContentHeaderProperties().getExpiration());
    }

    public void setJMSExpiration(long l) throws JMSException {
        this.getJmsContentHeaderProperties().setExpiration(l);
    }

    public int getJMSPriority() throws JMSException {
        return this.getJmsContentHeaderProperties().getPriority();
    }

    public void setJMSPriority(int i) throws JMSException {
        this.getJmsContentHeaderProperties().setPriority((byte)i);
    }

    public void clearProperties() throws JMSException {
        if (this.getJmsContentHeaderProperties().getHeaders() != null) {
            this.getJmsContentHeaderProperties().getHeaders().clear();
        }
    }

    public boolean propertyExists(String propertyName) throws JMSException {
        this.checkPropertyName(propertyName);
        if (this.getJmsContentHeaderProperties().getHeaders() == null) {
            return false;
        }
        return this.getJmsContentHeaderProperties().getHeaders().containsKey((Object)('S' + propertyName));
    }

    public boolean getBooleanProperty(String propertyName) throws JMSException {
        this.checkPropertyName(propertyName);
        if (this.getJmsContentHeaderProperties().getHeaders() == null) {
            return Boolean.valueOf(null);
        }
        Long b = (Long)this.getJmsContentHeaderProperties().getHeaders().get((Object)('B' + propertyName));
        if (b == null) {
            return Boolean.valueOf(null);
        }
        return b != 0L;
    }

    public byte getByteProperty(String propertyName) throws JMSException {
        this.checkPropertyName(propertyName);
        if (this.getJmsContentHeaderProperties().getHeaders() == null) {
            return Byte.valueOf(null);
        }
        Byte b = (Byte)this.getJmsContentHeaderProperties().getHeaders().get((Object)('b' + propertyName));
        if (b == null) {
            return Byte.valueOf(null);
        }
        return b;
    }

    public short getShortProperty(String propertyName) throws JMSException {
        this.checkPropertyName(propertyName);
        if (this.getJmsContentHeaderProperties().getHeaders() == null) {
            return Short.valueOf(null);
        }
        Short s = (Short)this.getJmsContentHeaderProperties().getHeaders().get((Object)('s' + propertyName));
        if (s == null) {
            return Short.valueOf(null);
        }
        return s;
    }

    public int getIntProperty(String propertyName) throws JMSException {
        this.checkPropertyName(propertyName);
        if (this.getJmsContentHeaderProperties().getHeaders() == null) {
            return Integer.valueOf(null);
        }
        Integer i = (Integer)this.getJmsContentHeaderProperties().getHeaders().get((Object)('i' + propertyName));
        if (i == null) {
            return Integer.valueOf(null);
        }
        return i;
    }

    public long getLongProperty(String propertyName) throws JMSException {
        this.checkPropertyName(propertyName);
        if (this.getJmsContentHeaderProperties().getHeaders() == null) {
            return Long.valueOf(null);
        }
        Long l = (Long)this.getJmsContentHeaderProperties().getHeaders().get((Object)('l' + propertyName));
        if (l == null) {
            return 0L;
        }
        return l;
    }

    public float getFloatProperty(String propertyName) throws JMSException {
        this.checkPropertyName(propertyName);
        if (this.getJmsContentHeaderProperties().getHeaders() == null) {
            return Float.valueOf(null).floatValue();
        }
        Float f = (Float)this.getJmsContentHeaderProperties().getHeaders().get((Object)('f' + propertyName));
        if (f == null) {
            return Float.valueOf(null).floatValue();
        }
        return f.floatValue();
    }

    public double getDoubleProperty(String propertyName) throws JMSException {
        this.checkPropertyName(propertyName);
        if (this.getJmsContentHeaderProperties().getHeaders() == null) {
            return Double.valueOf(null);
        }
        Double d = (Double)this.getJmsContentHeaderProperties().getHeaders().get((Object)('d' + propertyName));
        if (d == null) {
            return Double.valueOf(null);
        }
        return d.shortValue();
    }

    public String getStringProperty(String propertyName) throws JMSException {
        this.checkPropertyName(propertyName);
        if (this.getJmsContentHeaderProperties().getHeaders() == null) {
            return null;
        }
        return (String)this.getJmsContentHeaderProperties().getHeaders().get((Object)('S' + propertyName));
    }

    public Object getObjectProperty(String propertyName) throws JMSException {
        this.checkPropertyName(propertyName);
        throw new JmsNotImplementedException();
    }

    public Enumeration getPropertyNames() throws JMSException {
        return new FieldTableKeyEnumeration(this.getJmsContentHeaderProperties().getHeaders()){

            public Object nextElement() {
                String propName = (String)this._iterator.next();
                return propName.substring(1);
            }
        };
    }

    public void setBooleanProperty(String propertyName, boolean b) throws JMSException {
        this.checkPropertyName(propertyName);
        this.getJmsContentHeaderProperties().getHeaders().put((Object)('B' + propertyName), (Object)(b ? new Long(1L) : new Long(0L)));
    }

    public void setByteProperty(String propertyName, byte b) throws JMSException {
        this.checkPropertyName(propertyName);
        this.getJmsContentHeaderProperties().getHeaders().put((Object)('b' + propertyName), (Object)new Byte(b));
    }

    public void setShortProperty(String propertyName, short i) throws JMSException {
        this.checkPropertyName(propertyName);
        this.getJmsContentHeaderProperties().getHeaders().put((Object)('s' + propertyName), (Object)new Short(i));
    }

    public void setIntProperty(String propertyName, int i) throws JMSException {
        this.checkPropertyName(propertyName);
        this.getJmsContentHeaderProperties().getHeaders().put((Object)('i' + propertyName), (Object)new Integer(i));
    }

    public void setLongProperty(String propertyName, long l) throws JMSException {
        this.checkPropertyName(propertyName);
        this.getJmsContentHeaderProperties().getHeaders().put((Object)('l' + propertyName), (Object)new Long(l));
    }

    public void setFloatProperty(String propertyName, float f) throws JMSException {
        this.checkPropertyName(propertyName);
        this.getJmsContentHeaderProperties().getHeaders().put((Object)('f' + propertyName), (Object)new Float(f));
    }

    public void setDoubleProperty(String propertyName, double v) throws JMSException {
        this.checkPropertyName(propertyName);
        this.getJmsContentHeaderProperties().getHeaders().put((Object)('d' + propertyName), (Object)new Double(v));
    }

    public void setStringProperty(String propertyName, String value) throws JMSException {
        this.checkPropertyName(propertyName);
        this.createPropertyMapIfRequired();
        propertyName = 'S' + propertyName;
        this.getJmsContentHeaderProperties().getHeaders().put((Object)propertyName, (Object)value);
    }

    private void createPropertyMapIfRequired() {
        if (this.getJmsContentHeaderProperties().getHeaders() == null) {
            this.getJmsContentHeaderProperties().setHeaders(new FieldTable());
        }
    }

    public void setObjectProperty(String string, Object object) throws JMSException {
    }

    public void acknowledge() throws JMSException {
        if (this._session != null) {
            this._session.acknowledgeMessage(this._deliveryTag, true);
        }
    }

    public abstract void clearBody() throws JMSException;

    public abstract String toBodyString() throws JMSException;

    public abstract String getMimeType();

    public String toString() {
        try {
            StringBuffer buf = new StringBuffer("Body:\n");
            buf.append(this.toBodyString());
            buf.append("\nJMS timestamp: ").append(this.getJMSTimestamp());
            buf.append("\nJMS expiration: ").append(this.getJMSExpiration());
            buf.append("\nJMS priority: ").append(this.getJMSPriority());
            buf.append("\nJMS delivery mode: ").append(this.getJMSDeliveryMode());
            buf.append("\nJMS reply to: ").append(String.valueOf(this.getJMSReplyTo()));
            buf.append("\nAMQ message number: ").append(this._deliveryTag);
            buf.append("\nProperties:");
            if (this.getJmsContentHeaderProperties().getHeaders() == null) {
                buf.append("<NONE>");
            } else {
                for (Map.Entry entry : this.getJmsContentHeaderProperties().getHeaders().entrySet()) {
                    String propertyName = (String)entry.getKey();
                    if (propertyName == null) {
                        buf.append("\nInternal error: Property with NULL key defined");
                        continue;
                    }
                    buf.append('\n').append(propertyName.substring(1));
                    char typeIdentifier = propertyName.charAt(0);
                    switch (typeIdentifier) {
                        case 'B': {
                            buf.append("<boolean> ");
                            break;
                        }
                        case 'b': {
                            buf.append("<byte> ");
                            break;
                        }
                        case 's': {
                            buf.append("<short> ");
                            break;
                        }
                        case 'i': {
                            buf.append("<int> ");
                            break;
                        }
                        case 'l': {
                            buf.append("<long> ");
                            break;
                        }
                        case 'f': {
                            buf.append("<float> ");
                            break;
                        }
                        case 'd': {
                            buf.append("<double> ");
                            break;
                        }
                        case 'S': {
                            buf.append("<string> ");
                            break;
                        }
                        default: {
                            buf.append("<unknown type (identifier " + typeIdentifier + ") ");
                        }
                    }
                    buf.append(String.valueOf(entry.getValue()));
                }
            }
            return buf.toString();
        }
        catch (JMSException e) {
            return e.toString();
        }
    }

    public Map getUnderlyingMessagePropertiesMap() {
        return this.getJmsContentHeaderProperties().getHeaders();
    }

    public void setUnderlyingMessagePropertiesMap(FieldTable messageProperties) {
        this.getJmsContentHeaderProperties().setHeaders(messageProperties);
    }

    private void checkPropertyName(String propertyName) {
        if (propertyName == null) {
            throw new IllegalArgumentException("Property name must not be null");
        }
        if ("".equals(propertyName)) {
            throw new IllegalArgumentException("Property name must not be the empty string");
        }
        if (this.getJmsContentHeaderProperties().getHeaders() == null) {
            this.getJmsContentHeaderProperties().setHeaders(new FieldTable());
        }
    }

    public FieldTable populateHeadersFromMessageProperties() {
        if (this.getJmsContentHeaderProperties().getHeaders() == null) {
            return null;
        }
        FieldTable table = new FieldTable();
        for (Map.Entry entry : this.getJmsContentHeaderProperties().getHeaders().entrySet()) {
            String propertyName = (String)entry.getKey();
            if (propertyName == null) continue;
            table.put((Object)propertyName, (Object)entry.getValue().toString());
        }
        return table;
    }

    public BasicContentHeaderProperties getJmsContentHeaderProperties() {
        return (BasicContentHeaderProperties)this._contentHeaderProperties;
    }

    public ByteBuffer getData() {
        if (this._data != null) {
            this._data.rewind();
        }
        return this._data;
    }
}

