/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.client.message;

import java.util.List;
import javax.jms.JMSException;
import org.apache.log4j.Logger;
import org.apache.mina.common.ByteBuffer;
import org.apache.qpid.AMQException;
import org.apache.qpid.client.message.AbstractJMSMessage;
import org.apache.qpid.client.message.MessageFactory;
import org.apache.qpid.framing.ContentBody;
import org.apache.qpid.framing.ContentHeaderBody;

public abstract class AbstractJMSMessageFactory
implements MessageFactory {
    private static final Logger _logger = Logger.getLogger(AbstractJMSMessageFactory.class);

    protected abstract AbstractJMSMessage createMessage(long var1, ByteBuffer var3, ContentHeaderBody var4) throws AMQException;

    protected AbstractJMSMessage createMessageWithBody(long messageNbr, ContentHeaderBody contentHeader, List bodies) throws AMQException {
        ByteBuffer data;
        if (bodies != null && bodies.size() == 1) {
            _logger.debug((Object)("Non-fragmented message body (bodySize=" + contentHeader.bodySize + ")"));
            data = ((ContentBody)bodies.get((int)0)).payload;
        } else {
            _logger.debug((Object)("Fragmented message body (" + bodies.size() + " frames, bodySize=" + contentHeader.bodySize + ")"));
            data = ByteBuffer.allocate((int)((int)contentHeader.bodySize));
            for (ContentBody cb : bodies) {
                data.put(cb.payload);
                cb.payload.release();
            }
            data.flip();
        }
        _logger.debug((Object)("Creating message from buffer with position=" + data.position() + " and remaining=" + data.remaining()));
        return this.createMessage(messageNbr, data, contentHeader);
    }

    public AbstractJMSMessage createMessage(long messageNbr, boolean redelivered, ContentHeaderBody contentHeader, List bodies) throws JMSException, AMQException {
        AbstractJMSMessage msg = this.createMessageWithBody(messageNbr, contentHeader, bodies);
        msg.setJMSRedelivered(redelivered);
        return msg;
    }
}

