/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.client.message;

import java.io.IOException;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import javax.jms.BytesMessage;
import javax.jms.JMSException;
import javax.jms.MessageEOFException;
import javax.jms.MessageNotReadableException;
import javax.jms.MessageNotWriteableException;
import org.apache.mina.common.ByteBuffer;
import org.apache.qpid.AMQException;
import org.apache.qpid.client.message.AbstractJMSMessage;
import org.apache.qpid.framing.BasicContentHeaderProperties;
import org.apache.qpid.framing.ContentHeaderBody;

public class JMSBytesMessage
extends AbstractJMSMessage
implements BytesMessage {
    private static final String MIME_TYPE = "application/octet-stream";
    private boolean _readable = false;
    private static final int DEFAULT_BUFFER_INITIAL_SIZE = 1024;

    JMSBytesMessage() {
        this((ByteBuffer)null);
    }

    JMSBytesMessage(ByteBuffer data) {
        super(data);
        this.getJmsContentHeaderProperties().setContentType(MIME_TYPE);
        if (this._data == null) {
            this._data = ByteBuffer.allocate((int)1024);
            this._data.setAutoExpand(true);
        }
        this._readable = data != null;
    }

    JMSBytesMessage(long messageNbr, ByteBuffer data, ContentHeaderBody contentHeader) throws AMQException {
        super(messageNbr, (BasicContentHeaderProperties)contentHeader.properties, data);
        this.getJmsContentHeaderProperties().setContentType(MIME_TYPE);
        this._readable = true;
    }

    public void clearBody() throws JMSException {
        this._data.clear();
        this._readable = false;
    }

    public String toBodyString() throws JMSException {
        this.checkReadable();
        try {
            return this.getText();
        }
        catch (IOException e) {
            throw new JMSException(e.toString());
        }
    }

    private String getText() throws IOException {
        if (this._data == null) {
            return null;
        }
        int pos = this._data.position();
        this._data.rewind();
        if (this._data.remaining() == 0) {
            this._data.position(pos);
            return null;
        }
        String data = this._data.getString(Charset.forName("UTF8").newDecoder());
        this._data.position(pos);
        return data;
    }

    public String getMimeType() {
        return MIME_TYPE;
    }

    public long getBodyLength() throws JMSException {
        this.checkReadable();
        return this._data.limit();
    }

    private void checkReadable() throws MessageNotReadableException {
        if (!this._readable) {
            throw new MessageNotReadableException("You need to call reset() to make the message readable");
        }
    }

    private void checkAvailable(int len) throws MessageEOFException {
        if (this._data.remaining() < len) {
            throw new MessageEOFException("Unable to read " + len + " bytes");
        }
    }

    private void checkWritable() throws MessageNotWriteableException {
        if (this._readable) {
            throw new MessageNotWriteableException("You need to call clearBody() to make the message writable");
        }
    }

    public boolean readBoolean() throws JMSException {
        this.checkReadable();
        this.checkAvailable(1);
        return this._data.get() != 0;
    }

    public byte readByte() throws JMSException {
        this.checkReadable();
        this.checkAvailable(1);
        return this._data.get();
    }

    public int readUnsignedByte() throws JMSException {
        this.checkReadable();
        this.checkAvailable(1);
        return this._data.getUnsigned();
    }

    public short readShort() throws JMSException {
        this.checkReadable();
        this.checkAvailable(2);
        return this._data.getShort();
    }

    public int readUnsignedShort() throws JMSException {
        this.checkReadable();
        this.checkAvailable(2);
        return this._data.getUnsignedShort();
    }

    public char readChar() throws JMSException {
        this.checkReadable();
        this.checkAvailable(2);
        return this._data.getChar();
    }

    public int readInt() throws JMSException {
        this.checkReadable();
        this.checkAvailable(4);
        return this._data.getInt();
    }

    public long readLong() throws JMSException {
        this.checkReadable();
        this.checkAvailable(8);
        return this._data.getLong();
    }

    public float readFloat() throws JMSException {
        this.checkReadable();
        this.checkAvailable(4);
        return this._data.getFloat();
    }

    public double readDouble() throws JMSException {
        this.checkReadable();
        this.checkAvailable(8);
        return this._data.getDouble();
    }

    public String readUTF() throws JMSException {
        this.checkReadable();
        this.checkAvailable(1);
        try {
            return this._data.getString(Charset.forName("UTF-8").newDecoder());
        }
        catch (CharacterCodingException e) {
            JMSException je = new JMSException("Error decoding byte stream as a UTF8 string: " + e);
            je.setLinkedException((Exception)e);
            throw je;
        }
    }

    public int readBytes(byte[] bytes) throws JMSException {
        int count;
        if (bytes == null) {
            throw new IllegalArgumentException("byte array must not be null");
        }
        this.checkReadable();
        int n = count = this._data.remaining() >= bytes.length ? bytes.length : this._data.remaining();
        if (count == 0) {
            return -1;
        }
        this._data.get(bytes, 0, count);
        return count;
    }

    public int readBytes(byte[] bytes, int maxLength) throws JMSException {
        int count;
        if (bytes == null) {
            throw new IllegalArgumentException("byte array must not be null");
        }
        if (maxLength > bytes.length) {
            throw new IllegalArgumentException("maxLength must be <= bytes.length");
        }
        this.checkReadable();
        int n = count = this._data.remaining() >= maxLength ? maxLength : this._data.remaining();
        if (count == 0) {
            return -1;
        }
        this._data.get(bytes, 0, count);
        return count;
    }

    public void writeBoolean(boolean b) throws JMSException {
        this.checkWritable();
        this._data.put(b ? (byte)1 : 0);
    }

    public void writeByte(byte b) throws JMSException {
        this.checkWritable();
        this._data.put(b);
    }

    public void writeShort(short i) throws JMSException {
        this.checkWritable();
        this._data.putShort(i);
    }

    public void writeChar(char c) throws JMSException {
        this.checkWritable();
        this._data.putChar(c);
    }

    public void writeInt(int i) throws JMSException {
        this.checkWritable();
        this._data.putInt(i);
    }

    public void writeLong(long l) throws JMSException {
        this.checkWritable();
        this._data.putLong(l);
    }

    public void writeFloat(float v) throws JMSException {
        this.checkWritable();
        this._data.putFloat(v);
    }

    public void writeDouble(double v) throws JMSException {
        this.checkWritable();
        this._data.putDouble(v);
    }

    public void writeUTF(String string) throws JMSException {
        this.checkWritable();
        try {
            this._data.putString((CharSequence)string, Charset.forName("UTF-8").newEncoder());
        }
        catch (CharacterCodingException e) {
            JMSException ex = new JMSException("Unable to encode string: " + e);
            ex.setLinkedException((Exception)e);
            throw ex;
        }
    }

    public void writeBytes(byte[] bytes) throws JMSException {
        this.checkWritable();
        this._data.put(bytes);
    }

    public void writeBytes(byte[] bytes, int offset, int length) throws JMSException {
        this.checkWritable();
        this._data.put(bytes, offset, length);
    }

    public void writeObject(Object object) throws JMSException {
        this.checkWritable();
        if (object == null) {
            throw new NullPointerException("Argument must not be null");
        }
        this._data.putObject(object);
    }

    public void reset() throws JMSException {
        this._data.flip();
        this._readable = true;
    }

    public boolean isReadable() {
        return this._readable;
    }
}

