/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.client.message;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import javax.jms.JMSException;
import javax.jms.MessageFormatException;
import javax.jms.MessageNotWriteableException;
import javax.jms.ObjectMessage;
import org.apache.mina.common.ByteBuffer;
import org.apache.qpid.AMQException;
import org.apache.qpid.client.message.AbstractJMSMessage;
import org.apache.qpid.framing.BasicContentHeaderProperties;
import org.apache.qpid.framing.ContentHeaderBody;

public class JMSObjectMessage
extends AbstractJMSMessage
implements ObjectMessage {
    static final String MIME_TYPE = "application/java-object-stream";
    private final boolean _readonly;
    private static final int DEFAULT_BUFFER_SIZE = 1024;

    JMSObjectMessage() {
        this((ByteBuffer)null);
    }

    private JMSObjectMessage(ByteBuffer data) {
        super(data);
        if (data == null) {
            this._data = ByteBuffer.allocate((int)1024);
            this._data.setAutoExpand(true);
        }
        this._readonly = data != null;
        this.getJmsContentHeaderProperties().setContentType(MIME_TYPE);
    }

    JMSObjectMessage(long messageNbr, ByteBuffer data, ContentHeaderBody contentHeader) throws AMQException {
        super(messageNbr, (BasicContentHeaderProperties)contentHeader.properties, data);
        this._readonly = data != null;
    }

    public void clearBody() throws JMSException {
        if (this._data != null) {
            this._data.release();
        }
        this._data = null;
    }

    public String toBodyString() throws JMSException {
        return JMSObjectMessage.toString(this._data);
    }

    public String getMimeType() {
        return MIME_TYPE;
    }

    public void setObject(Serializable serializable) throws JMSException {
        if (this._readonly) {
            throw new MessageNotWriteableException("Message is not writable.");
        }
        if (this._data == null) {
            this._data = ByteBuffer.allocate((int)1024);
            this._data.setAutoExpand(true);
        }
        try {
            ObjectOutputStream out = new ObjectOutputStream(this._data.asOutputStream());
            out.writeObject(serializable);
            out.flush();
            out.close();
            this._data.rewind();
        }
        catch (IOException e) {
            throw new MessageFormatException("Message not serializable: " + e);
        }
    }

    public Serializable getObject() throws JMSException {
        ObjectInputStream in = null;
        if (this._data == null) {
            return null;
        }
        try {
            in = new ObjectInputStream(this._data.asInputStream());
            Serializable serializable = (Serializable)in.readObject();
            return serializable;
        }
        catch (IOException e) {
            throw new MessageFormatException("Could not deserialize message: " + e);
        }
        catch (ClassNotFoundException e) {
            throw new MessageFormatException("Could not deserialize message: " + e);
        }
        finally {
            this._data.rewind();
            JMSObjectMessage.close(in);
        }
    }

    private static void close(InputStream in) {
        try {
            if (in != null) {
                in.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String toString(ByteBuffer data) {
        if (data == null) {
            return null;
        }
        int pos = data.position();
        try {
            String string = data.getString(Charset.forName("UTF8").newDecoder());
            return string;
        }
        catch (CharacterCodingException e) {
            String string = null;
            return string;
        }
        finally {
            data.position(pos);
        }
    }
}

