/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.client.message;

import java.io.UnsupportedEncodingException;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import javax.jms.JMSException;
import javax.jms.TextMessage;
import org.apache.mina.common.ByteBuffer;
import org.apache.qpid.AMQException;
import org.apache.qpid.client.message.AbstractJMSMessage;
import org.apache.qpid.framing.BasicContentHeaderProperties;

public class JMSTextMessage
extends AbstractJMSMessage
implements TextMessage {
    private static final String MIME_TYPE = "text/plain";
    private String _decodedValue;

    JMSTextMessage() throws JMSException {
        this(null, null);
    }

    JMSTextMessage(ByteBuffer data, String encoding) throws JMSException {
        super(data);
        this.getJmsContentHeaderProperties().setContentType(MIME_TYPE);
        this.getJmsContentHeaderProperties().setEncoding(encoding);
    }

    JMSTextMessage(long deliveryTag, ByteBuffer data, BasicContentHeaderProperties contentHeader) throws AMQException {
        super(deliveryTag, contentHeader, data);
        contentHeader.setContentType(MIME_TYPE);
        this._data = data;
    }

    JMSTextMessage(ByteBuffer data) throws JMSException {
        this(data, null);
    }

    JMSTextMessage(String text) throws JMSException {
        super((ByteBuffer)null);
        this.setText(text);
    }

    public void clearBody() throws JMSException {
        if (this._data != null) {
            this._data.release();
        }
        this._data = null;
        this._decodedValue = null;
    }

    public String toBodyString() throws JMSException {
        return this.getText();
    }

    public void setData(ByteBuffer data) {
        this._data = data;
    }

    public String getMimeType() {
        return MIME_TYPE;
    }

    public void setText(String string) throws JMSException {
        this.clearBody();
        try {
            this._data = ByteBuffer.allocate((int)string.length());
            this._data.limit(string.length());
            this._data.setAutoExpand(true);
            if (this.getJmsContentHeaderProperties().getEncoding() == null) {
                this._data.put(string.getBytes());
            } else {
                this._data.put(string.getBytes(this.getJmsContentHeaderProperties().getEncoding()));
            }
            this._decodedValue = string;
        }
        catch (UnsupportedEncodingException e) {
            throw new JMSException("Unable to decode string data");
        }
    }

    public String getText() throws JMSException {
        if (this._data == null && this._decodedValue == null) {
            return null;
        }
        if (this._decodedValue != null) {
            return this._decodedValue;
        }
        this._data.rewind();
        if (this.getJmsContentHeaderProperties().getEncoding() != null) {
            try {
                this._decodedValue = this._data.getString(Charset.forName(this.getJmsContentHeaderProperties().getEncoding()).newDecoder());
            }
            catch (CharacterCodingException e) {
                JMSException je = new JMSException("Could not decode string data: " + e);
                je.setLinkedException((Exception)e);
                throw je;
            }
        }
        try {
            this._decodedValue = this._data.getString(Charset.defaultCharset().newDecoder());
        }
        catch (CharacterCodingException e) {
            JMSException je = new JMSException("Could not decode string data: " + e);
            je.setLinkedException((Exception)e);
            throw je;
        }
        return this._decodedValue;
    }
}

