/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.client.message;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.jms.JMSException;
import org.apache.qpid.AMQException;
import org.apache.qpid.client.message.AbstractJMSMessage;
import org.apache.qpid.client.message.JMSBytesMessageFactory;
import org.apache.qpid.client.message.JMSObjectMessageFactory;
import org.apache.qpid.client.message.JMSTextMessageFactory;
import org.apache.qpid.client.message.MessageFactory;
import org.apache.qpid.framing.BasicContentHeaderProperties;
import org.apache.qpid.framing.ContentHeaderBody;

public class MessageFactoryRegistry {
    private final Map _mimeToFactoryMap = new HashMap();

    public void registerFactory(String mimeType, MessageFactory mf) {
        if (mf == null) {
            throw new IllegalArgumentException("Message factory must not be null");
        }
        this._mimeToFactoryMap.put(mimeType, mf);
    }

    public MessageFactory deregisterFactory(String mimeType) {
        return (MessageFactory)this._mimeToFactoryMap.remove(mimeType);
    }

    public AbstractJMSMessage createMessage(long deliveryTag, boolean redelivered, ContentHeaderBody contentHeader, List bodies) throws AMQException, JMSException {
        BasicContentHeaderProperties properties = (BasicContentHeaderProperties)contentHeader.properties;
        MessageFactory mf = (MessageFactory)this._mimeToFactoryMap.get(properties.getContentType());
        if (mf == null) {
            throw new AMQException("Unsupport MIME type of " + properties.getContentType());
        }
        return mf.createMessage(deliveryTag, redelivered, contentHeader, bodies);
    }

    public AbstractJMSMessage createMessage(String mimeType) throws AMQException, JMSException {
        if (mimeType == null) {
            throw new IllegalArgumentException("Mime type must not be null");
        }
        MessageFactory mf = (MessageFactory)this._mimeToFactoryMap.get(mimeType);
        if (mf == null) {
            throw new AMQException("Unsupport MIME type of " + mimeType);
        }
        return mf.createMessage();
    }

    public static MessageFactoryRegistry newDefaultRegistry() {
        MessageFactoryRegistry mf = new MessageFactoryRegistry();
        mf.registerFactory("text/plain", new JMSTextMessageFactory());
        mf.registerFactory("text/xml", new JMSTextMessageFactory());
        mf.registerFactory("application/octet-stream", new JMSBytesMessageFactory());
        mf.registerFactory("application/java-object-stream", new JMSObjectMessageFactory());
        mf.registerFactory(null, new JMSBytesMessageFactory());
        return mf;
    }
}

