/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.client.protocol;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.jms.JMSException;
import javax.security.sasl.SaslClient;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.apache.mina.common.CloseFuture;
import org.apache.mina.common.IdleStatus;
import org.apache.mina.common.IoSession;
import org.apache.mina.common.WriteFuture;
import org.apache.qpid.AMQException;
import org.apache.qpid.client.AMQConnection;
import org.apache.qpid.client.AMQSession;
import org.apache.qpid.client.ConnectionTuneParameters;
import org.apache.qpid.client.message.UnexpectedBodyReceivedException;
import org.apache.qpid.client.message.UnprocessedMessage;
import org.apache.qpid.client.protocol.AMQProtocolHandler;
import org.apache.qpid.client.protocol.HeartbeatConfig;
import org.apache.qpid.client.protocol.HeartbeatDiagnostics;
import org.apache.qpid.framing.AMQDataBlock;
import org.apache.qpid.framing.ContentBody;
import org.apache.qpid.framing.ContentHeaderBody;
import org.apache.qpid.framing.ProtocolInitiation;
import org.apache.qpid.framing.ProtocolVersionList;

public class AMQProtocolSession
implements ProtocolVersionList {
    protected static final int LAST_WRITE_FUTURE_JOIN_TIMEOUT = 120000;
    protected static final Logger _logger = Logger.getLogger(AMQProtocolSession.class);
    public static final String PROTOCOL_INITIATION_RECEIVED = "ProtocolInitiatiionReceived";
    protected static final String CONNECTION_TUNE_PARAMETERS = "ConnectionTuneParameters";
    protected static final String AMQ_CONNECTION = "AMQConnection";
    protected static final String SASL_CLIENT = "SASLClient";
    protected final IoSession _minaProtocolSession;
    protected WriteFuture _lastWriteFuture;
    protected final AMQProtocolHandler _protocolHandler;
    protected ConcurrentMap _channelId2SessionMap = new ConcurrentHashMap();
    protected ConcurrentMap _closingChannels = new ConcurrentHashMap();
    protected ConcurrentMap _channelId2UnprocessedMsgMap = new ConcurrentHashMap();
    protected int _queueId = 1;
    protected final Object _queueIdLock = new Object();

    public AMQProtocolSession() {
        this._protocolHandler = null;
        this._minaProtocolSession = null;
    }

    public AMQProtocolSession(AMQProtocolHandler protocolHandler, IoSession protocolSession, AMQConnection connection) {
        this._protocolHandler = protocolHandler;
        this._minaProtocolSession = protocolSession;
        this._minaProtocolSession.setAttribute(AMQ_CONNECTION, (Object)connection);
    }

    public void init() {
        int i = pv.length - 1;
        this._minaProtocolSession.write((Object)new ProtocolInitiation(pv[i][0], pv[i][1]));
    }

    public String getClientID() {
        try {
            return this.getAMQConnection().getClientID();
        }
        catch (JMSException e) {
            return null;
        }
    }

    public void setClientID(String clientID) throws JMSException {
        this.getAMQConnection().setClientID(clientID);
    }

    public String getVirtualHost() {
        return this.getAMQConnection().getVirtualHost();
    }

    public String getUsername() {
        return this.getAMQConnection().getUsername();
    }

    public String getPassword() {
        return this.getAMQConnection().getPassword();
    }

    public IoSession getIoSession() {
        return this._minaProtocolSession;
    }

    public SaslClient getSaslClient() {
        return (SaslClient)this._minaProtocolSession.getAttribute(SASL_CLIENT);
    }

    public void setSaslClient(SaslClient client) {
        if (client == null) {
            this._minaProtocolSession.removeAttribute(SASL_CLIENT);
        } else {
            this._minaProtocolSession.setAttribute(SASL_CLIENT, (Object)client);
        }
    }

    public ConnectionTuneParameters getConnectionTuneParameters() {
        return (ConnectionTuneParameters)this._minaProtocolSession.getAttribute(CONNECTION_TUNE_PARAMETERS);
    }

    public void setConnectionTuneParameters(ConnectionTuneParameters params) {
        this._minaProtocolSession.setAttribute(CONNECTION_TUNE_PARAMETERS, (Object)params);
        AMQConnection con = this.getAMQConnection();
        con.setMaximumChannelCount(params.getChannelMax());
        con.setMaximumFrameSize(params.getFrameMax());
        this.initHeartbeats(params.getHeartbeat());
    }

    public void unprocessedMessageReceived(UnprocessedMessage message) throws AMQException {
        this._channelId2UnprocessedMsgMap.put(message.channelId, message);
    }

    public void messageContentHeaderReceived(int channelId, ContentHeaderBody contentHeader) throws AMQException {
        UnprocessedMessage msg = (UnprocessedMessage)this._channelId2UnprocessedMsgMap.get(channelId);
        if (msg == null) {
            throw new AMQException("Error: received content header without having received a BasicDeliver frame first");
        }
        if (msg.contentHeader != null) {
            throw new AMQException("Error: received duplicate content header or did not receive correct number of content body frames");
        }
        msg.contentHeader = contentHeader;
        if (contentHeader.bodySize == 0L) {
            this.deliverMessageToAMQSession(channelId, msg);
        }
    }

    public void messageContentBodyReceived(int channelId, ContentBody contentBody) throws AMQException {
        UnprocessedMessage msg = (UnprocessedMessage)this._channelId2UnprocessedMsgMap.get(channelId);
        if (msg == null) {
            throw new AMQException("Error: received content body without having received a JMSDeliver frame first");
        }
        if (msg.contentHeader == null) {
            this._channelId2UnprocessedMsgMap.remove(channelId);
            throw new AMQException("Error: received content body without having received a ContentHeader frame first");
        }
        try {
            msg.receiveBody(contentBody);
        }
        catch (UnexpectedBodyReceivedException e) {
            this._channelId2UnprocessedMsgMap.remove(channelId);
            throw e;
        }
        if (msg.isAllBodyDataReceived()) {
            this.deliverMessageToAMQSession(channelId, msg);
        }
    }

    private void deliverMessageToAMQSession(int channelId, UnprocessedMessage msg) {
        AMQSession session = (AMQSession)this._channelId2SessionMap.get(channelId);
        session.messageReceived(msg);
        this._channelId2UnprocessedMsgMap.remove(channelId);
    }

    public void writeFrame(AMQDataBlock frame) {
        this.writeFrame(frame, false);
    }

    public void writeFrame(AMQDataBlock frame, boolean wait) {
        WriteFuture f = this._minaProtocolSession.write((Object)frame);
        if (wait) {
            f.join();
        } else {
            this._lastWriteFuture = f;
        }
    }

    public void addSessionByChannel(int channelId, AMQSession session) {
        if (channelId <= 0) {
            throw new IllegalArgumentException("Attempt to register a session with a channel id <= zero");
        }
        if (session == null) {
            throw new IllegalArgumentException("Attempt to register a null session");
        }
        _logger.debug((Object)("Add session with channel id  " + channelId));
        this._channelId2SessionMap.put(channelId, session);
    }

    public void removeSessionByChannel(int channelId) {
        if (channelId <= 0) {
            throw new IllegalArgumentException("Attempt to deregister a session with a channel id <= zero");
        }
        _logger.debug((Object)("Removing session with channelId " + channelId));
        this._channelId2SessionMap.remove(channelId);
    }

    public void closeSession(AMQSession session) {
        _logger.debug((Object)("closeSession called on protocol session for session " + session.getChannelId()));
        int channelId = session.getChannelId();
        if (channelId <= 0) {
            throw new IllegalArgumentException("Attempt to close a channel with id < 0");
        }
        this._closingChannels.putIfAbsent(channelId, session);
    }

    public boolean channelClosed(int channelId, int code, String text) {
        Integer chId = channelId;
        if (this._closingChannels.remove(chId) == null) {
            AMQSession session = (AMQSession)this._channelId2SessionMap.get(chId);
            session.closed(new AMQException(_logger, code, text));
            return true;
        }
        return false;
    }

    public AMQConnection getAMQConnection() {
        return (AMQConnection)this._minaProtocolSession.getAttribute(AMQ_CONNECTION);
    }

    public void closeProtocolSession() {
        _logger.debug((Object)"Waiting for last write to join.");
        if (this._lastWriteFuture != null) {
            this._lastWriteFuture.join(120000L);
        }
        _logger.debug((Object)"Closing protocol session");
        CloseFuture future = this._minaProtocolSession.close();
        future.join();
    }

    public void failover(String host, int port) {
        this._protocolHandler.failover(host, port);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String generateQueueName() {
        int id;
        Object object = this._queueIdLock;
        synchronized (object) {
            id = this._queueId++;
        }
        String localAddress = StringUtils.replaceChars((String)this._minaProtocolSession.getLocalAddress().toString(), (String)"/;:", (String)"");
        return "tmp_" + localAddress + "_" + id;
    }

    void initHeartbeats(int delay) {
        if (delay > 0) {
            this._minaProtocolSession.setIdleTime(IdleStatus.WRITER_IDLE, delay);
            this._minaProtocolSession.setIdleTime(IdleStatus.READER_IDLE, HeartbeatConfig.CONFIG.getTimeout(delay));
            HeartbeatDiagnostics.init(delay, HeartbeatConfig.CONFIG.getTimeout(delay));
        }
    }
}

