/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.client.protocol;

import org.apache.qpid.AMQException;
import org.apache.qpid.client.protocol.AMQMethodEvent;
import org.apache.qpid.client.protocol.AMQMethodListener;
import org.apache.qpid.framing.AMQMethodBody;

public abstract class BlockingMethodFrameListener
implements AMQMethodListener {
    private volatile boolean _ready = false;
    private final Object _lock = new Object();
    private volatile Exception _error;
    protected int _channelId;
    protected AMQMethodEvent _doneEvt = null;

    public abstract boolean processMethod(int var1, AMQMethodBody var2) throws AMQException;

    public BlockingMethodFrameListener(int channelId) {
        this._channelId = channelId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean methodReceived(AMQMethodEvent evt) throws AMQException {
        AMQMethodBody method = evt.getMethod();
        try {
            boolean ready;
            boolean bl = ready = evt.getChannelId() == this._channelId && this.processMethod(evt.getChannelId(), method);
            if (ready) {
                Object object = this._lock;
                synchronized (object) {
                    this._doneEvt = evt;
                    this._ready = ready;
                    this._lock.notify();
                }
            }
            return ready;
        }
        catch (AMQException e) {
            this.error((Exception)((Object)e));
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AMQMethodEvent blockForFrame() throws AMQException {
        Object object = this._lock;
        synchronized (object) {
            while (!this._ready) {
                try {
                    this._lock.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        if (this._error != null) {
            if (this._error instanceof AMQException) {
                throw (AMQException)((Object)this._error);
            }
            throw new AMQException("Woken up due to exception", (Throwable)this._error);
        }
        return this._doneEvt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void error(Exception e) {
        this._error = e;
        Object object = this._lock;
        synchronized (object) {
            this._ready = true;
            this._lock.notify();
        }
    }
}

