/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.client.protocol;

import org.apache.log4j.Logger;
import org.apache.mina.common.IoFilter;
import org.apache.mina.common.IoFilterAdapter;
import org.apache.mina.common.IoSession;

public class ProtocolBufferMonitorFilter
extends IoFilterAdapter {
    private static final Logger _logger = Logger.getLogger(ProtocolBufferMonitorFilter.class);
    public static long DEFAULT_FREQUENCY = 5000L;
    public static int DEFAULT_THRESHOLD = 3000;
    private int _bufferedMessages = 0;
    private int _threshold;
    private long _lastMessageOutputTime;
    private long _outputFrequencyInMillis;

    public ProtocolBufferMonitorFilter() {
        this._threshold = DEFAULT_THRESHOLD;
        this._outputFrequencyInMillis = DEFAULT_FREQUENCY;
    }

    public ProtocolBufferMonitorFilter(int threshold, long frequency) {
        this._threshold = threshold;
        this._outputFrequencyInMillis = frequency;
    }

    public void messageReceived(IoFilter.NextFilter nextFilter, IoSession session, Object message) throws Exception {
        long now;
        ++this._bufferedMessages;
        if (this._bufferedMessages > this._threshold && (now = System.currentTimeMillis()) - this._lastMessageOutputTime > this._outputFrequencyInMillis) {
            _logger.warn((Object)("Protocol message buffer exceeded threshold of " + this._threshold + ". Current backlog: " + this._bufferedMessages));
            this._lastMessageOutputTime = now;
        }
        nextFilter.messageReceived(session, message);
    }

    public void messageSent(IoFilter.NextFilter nextFilter, IoSession session, Object message) throws Exception {
        --this._bufferedMessages;
        nextFilter.messageSent(session, message);
    }

    public int getBufferedMessages() {
        return this._bufferedMessages;
    }

    public int getThreshold() {
        return this._threshold;
    }

    public void setThreshold(int threshold) {
        this._threshold = threshold;
    }

    public long getOutputFrequencyInMillis() {
        return this._outputFrequencyInMillis;
    }

    public void setOutputFrequencyInMillis(long outputFrequencyInMillis) {
        this._outputFrequencyInMillis = outputFrequencyInMillis;
    }

    public long getLastMessageOutputTime() {
        return this._lastMessageOutputTime;
    }
}

