/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.client.security;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.log4j.Logger;
import org.apache.qpid.client.security.AMQCallbackHandler;
import org.apache.qpid.client.security.DynamicSaslRegistrar;

public class CallbackHandlerRegistry {
    private static final String FILE_PROPERTY = "amq.callbackhandler.properties";
    private static final Logger _logger = Logger.getLogger(CallbackHandlerRegistry.class);
    private static CallbackHandlerRegistry _instance = new CallbackHandlerRegistry();
    private Map _mechanismToHandlerClassMap = new HashMap();
    private String _mechanisms;

    public static CallbackHandlerRegistry getInstance() {
        return _instance;
    }

    public Class getCallbackHandlerClass(String mechanism) {
        return (Class)this._mechanismToHandlerClassMap.get(mechanism);
    }

    public String getMechanisms() {
        return this._mechanisms;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CallbackHandlerRegistry() {
        DynamicSaslRegistrar.registerSaslProviders();
        InputStream is = this.openPropertiesInputStream();
        try {
            Properties props = new Properties();
            props.load(is);
            this.parseProperties(props);
            _logger.info((Object)("Available SASL mechanisms: " + this._mechanisms));
        }
        catch (IOException e) {
            _logger.error((Object)("Error reading properties: " + e), (Throwable)e);
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {
                    _logger.error((Object)("Unable to close properties stream: " + e), (Throwable)e);
                }
            }
        }
    }

    private InputStream openPropertiesInputStream() {
        String filename = System.getProperty(FILE_PROPERTY);
        boolean useDefault = true;
        InputStream is = null;
        if (filename != null) {
            try {
                is = new BufferedInputStream(new FileInputStream(new File(filename)));
                useDefault = false;
            }
            catch (FileNotFoundException e) {
                _logger.error((Object)("Unable to read from file " + filename + ": " + e), (Throwable)e);
            }
        }
        if (useDefault) {
            is = CallbackHandlerRegistry.class.getResourceAsStream("CallbackHandlerRegistry.properties");
        }
        return is;
    }

    private void parseProperties(Properties props) {
        Enumeration<?> e = props.propertyNames();
        while (e.hasMoreElements()) {
            String propertyName = (String)e.nextElement();
            int period = propertyName.indexOf(".");
            if (period < 0) {
                _logger.warn((Object)("Unable to parse property " + propertyName + " when configuring SASL providers"));
                continue;
            }
            String mechanism = propertyName.substring(period + 1);
            String className = props.getProperty(propertyName);
            Class<?> clazz = null;
            try {
                clazz = Class.forName(className);
                if (!AMQCallbackHandler.class.isAssignableFrom(clazz)) {
                    _logger.warn((Object)("SASL provider " + clazz + " does not implement " + AMQCallbackHandler.class + ". Skipping"));
                    continue;
                }
                this._mechanismToHandlerClassMap.put(mechanism, clazz);
                if (this._mechanisms == null) {
                    this._mechanisms = mechanism;
                    continue;
                }
                this._mechanisms = this._mechanisms + " " + mechanism;
            }
            catch (ClassNotFoundException ex) {
                _logger.warn((Object)("Unable to load class " + className + ". Skipping that SASL provider"));
            }
        }
    }
}

