/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.client.security;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.security.Security;
import java.util.Enumeration;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import javax.security.sasl.SaslClientFactory;
import org.apache.log4j.Logger;
import org.apache.qpid.client.security.CallbackHandlerRegistry;
import org.apache.qpid.client.security.JCAProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DynamicSaslRegistrar {
    private static final String FILE_PROPERTY = "amq.dynamicsaslregistrar.properties";
    private static final Logger _logger = Logger.getLogger(DynamicSaslRegistrar.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerSaslProviders() {
        InputStream is = DynamicSaslRegistrar.openPropertiesInputStream();
        try {
            Properties props = new Properties();
            props.load(is);
            Map<String, Class<? extends SaslClientFactory>> factories = DynamicSaslRegistrar.parseProperties(props);
            if (factories.size() > 0) {
                Security.addProvider(new JCAProvider(factories));
                _logger.debug((Object)"Dynamic SASL provider added as a security provider");
            }
        }
        catch (IOException e) {
            _logger.error((Object)("Error reading properties: " + e), (Throwable)e);
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {
                    _logger.error((Object)("Unable to close properties stream: " + e), (Throwable)e);
                }
            }
        }
    }

    private static InputStream openPropertiesInputStream() {
        String filename = System.getProperty(FILE_PROPERTY);
        boolean useDefault = true;
        InputStream is = null;
        if (filename != null) {
            try {
                is = new BufferedInputStream(new FileInputStream(new File(filename)));
                useDefault = false;
            }
            catch (FileNotFoundException e) {
                _logger.error((Object)("Unable to read from file " + filename + ": " + e), (Throwable)e);
            }
        }
        if (useDefault) {
            is = CallbackHandlerRegistry.class.getResourceAsStream("DynamicSaslRegistrar.properties");
        }
        return is;
    }

    private static Map<String, Class<? extends SaslClientFactory>> parseProperties(Properties props) {
        Enumeration<?> e = props.propertyNames();
        TreeMap<String, Class<? extends SaslClientFactory>> factoriesToRegister = new TreeMap<String, Class<? extends SaslClientFactory>>();
        while (e.hasMoreElements()) {
            String mechanism = (String)e.nextElement();
            String className = props.getProperty(mechanism);
            try {
                Class<?> clazz = Class.forName(className);
                if (!SaslClientFactory.class.isAssignableFrom(clazz)) {
                    _logger.error((Object)("Class " + clazz + " does not implement " + SaslClientFactory.class + " - skipping"));
                    continue;
                }
                factoriesToRegister.put(mechanism, clazz);
            }
            catch (Exception ex) {
                _logger.error((Object)("Error instantiating SaslClientFactory calss " + className + " - skipping"));
            }
        }
        return factoriesToRegister;
    }
}

