/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.client.security;

import java.io.IOException;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import org.apache.qpid.client.protocol.AMQProtocolSession;
import org.apache.qpid.client.security.AMQCallbackHandler;

public class UsernamePasswordCallbackHandler
implements AMQCallbackHandler {
    private AMQProtocolSession _protocolSession;

    public void initialise(AMQProtocolSession protocolSession) {
        this._protocolSession = protocolSession;
    }

    public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
        for (int i = 0; i < callbacks.length; ++i) {
            Callback cb = callbacks[i];
            if (cb instanceof NameCallback) {
                ((NameCallback)cb).setName(this._protocolSession.getUsername());
                continue;
            }
            if (cb instanceof PasswordCallback) {
                ((PasswordCallback)cb).setPassword(this._protocolSession.getPassword().toCharArray());
                continue;
            }
            throw new UnsupportedCallbackException(cb);
        }
    }
}

