/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.client.state;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArraySet;
import org.apache.log4j.Logger;
import org.apache.qpid.AMQException;
import org.apache.qpid.client.handler.BasicDeliverMethodHandler;
import org.apache.qpid.client.handler.BasicReturnMethodHandler;
import org.apache.qpid.client.handler.ChannelCloseMethodHandler;
import org.apache.qpid.client.handler.ChannelCloseOkMethodHandler;
import org.apache.qpid.client.handler.ChannelFlowOkMethodHandler;
import org.apache.qpid.client.handler.ConnectionCloseMethodHandler;
import org.apache.qpid.client.handler.ConnectionOpenOkMethodHandler;
import org.apache.qpid.client.handler.ConnectionSecureMethodHandler;
import org.apache.qpid.client.handler.ConnectionStartMethodHandler;
import org.apache.qpid.client.handler.ConnectionTuneMethodHandler;
import org.apache.qpid.client.protocol.AMQMethodEvent;
import org.apache.qpid.client.protocol.AMQMethodListener;
import org.apache.qpid.client.state.AMQState;
import org.apache.qpid.client.state.IllegalStateTransitionException;
import org.apache.qpid.client.state.StateAwareMethodListener;
import org.apache.qpid.client.state.StateListener;
import org.apache.qpid.client.state.StateWaiter;
import org.apache.qpid.framing.AMQMethodBody;
import org.apache.qpid.framing.BasicDeliverBody;
import org.apache.qpid.framing.BasicReturnBody;
import org.apache.qpid.framing.ChannelCloseBody;
import org.apache.qpid.framing.ChannelCloseOkBody;
import org.apache.qpid.framing.ChannelFlowOkBody;
import org.apache.qpid.framing.ConnectionCloseBody;
import org.apache.qpid.framing.ConnectionOpenOkBody;
import org.apache.qpid.framing.ConnectionSecureBody;
import org.apache.qpid.framing.ConnectionStartBody;
import org.apache.qpid.framing.ConnectionTuneBody;

public class AMQStateManager
implements AMQMethodListener {
    private static final Logger _logger = Logger.getLogger(AMQStateManager.class);
    private AMQState _currentState;
    private final Map _state2HandlersMap = new HashMap();
    private final CopyOnWriteArraySet _stateListeners = new CopyOnWriteArraySet();

    public AMQStateManager() {
        this(AMQState.CONNECTION_NOT_STARTED, true);
    }

    protected AMQStateManager(AMQState state, boolean register) {
        this._currentState = state;
        if (register) {
            this.registerListeners();
        }
    }

    protected void registerListeners() {
        HashMap<Class<ChannelFlowOkBody>, StateAwareMethodListener> frame2handlerMap = new HashMap<Class<ChannelFlowOkBody>, StateAwareMethodListener>();
        this._state2HandlersMap.put(null, frame2handlerMap);
        frame2handlerMap = new HashMap();
        frame2handlerMap.put(ConnectionStartBody.class, ConnectionStartMethodHandler.getInstance());
        frame2handlerMap.put(ConnectionCloseBody.class, ConnectionCloseMethodHandler.getInstance());
        this._state2HandlersMap.put(AMQState.CONNECTION_NOT_STARTED, frame2handlerMap);
        frame2handlerMap = new HashMap();
        frame2handlerMap.put(ConnectionTuneBody.class, ConnectionTuneMethodHandler.getInstance());
        frame2handlerMap.put(ConnectionSecureBody.class, ConnectionSecureMethodHandler.getInstance());
        frame2handlerMap.put(ConnectionCloseBody.class, ConnectionCloseMethodHandler.getInstance());
        this._state2HandlersMap.put(AMQState.CONNECTION_NOT_TUNED, frame2handlerMap);
        frame2handlerMap = new HashMap();
        frame2handlerMap.put(ConnectionOpenOkBody.class, ConnectionOpenOkMethodHandler.getInstance());
        frame2handlerMap.put(ConnectionCloseBody.class, ConnectionCloseMethodHandler.getInstance());
        this._state2HandlersMap.put(AMQState.CONNECTION_NOT_OPENED, frame2handlerMap);
        frame2handlerMap = new HashMap();
        frame2handlerMap.put(ChannelCloseBody.class, ChannelCloseMethodHandler.getInstance());
        frame2handlerMap.put(ChannelCloseOkBody.class, ChannelCloseOkMethodHandler.getInstance());
        frame2handlerMap.put(ConnectionCloseBody.class, ConnectionCloseMethodHandler.getInstance());
        frame2handlerMap.put(BasicDeliverBody.class, BasicDeliverMethodHandler.getInstance());
        frame2handlerMap.put(BasicReturnBody.class, BasicReturnMethodHandler.getInstance());
        frame2handlerMap.put(ChannelFlowOkBody.class, ChannelFlowOkMethodHandler.getInstance());
        this._state2HandlersMap.put(AMQState.CONNECTION_OPEN, frame2handlerMap);
    }

    public AMQState getCurrentState() {
        return this._currentState;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void changeState(AMQState newState) throws AMQException {
        _logger.debug((Object)("State changing to " + newState + " from old state " + this._currentState));
        AMQState oldState = this._currentState;
        this._currentState = newState;
        CopyOnWriteArraySet copyOnWriteArraySet = this._stateListeners;
        synchronized (copyOnWriteArraySet) {
            for (StateListener l : this._stateListeners) {
                l.stateChanged(oldState, newState);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void error(Exception e) {
        _logger.debug((Object)("State manager receive error notification: " + e));
        CopyOnWriteArraySet copyOnWriteArraySet = this._stateListeners;
        synchronized (copyOnWriteArraySet) {
            for (StateListener l : this._stateListeners) {
                l.error(e);
            }
        }
    }

    public boolean methodReceived(AMQMethodEvent evt) throws AMQException {
        StateAwareMethodListener handler = this.findStateTransitionHandler(this._currentState, evt.getMethod());
        if (handler != null) {
            handler.methodReceived(this, evt);
            return true;
        }
        return false;
    }

    protected StateAwareMethodListener findStateTransitionHandler(AMQState currentState, AMQMethodBody frame) throws IllegalStateTransitionException {
        Map classToHandlerMap;
        Class<?> clazz = frame.getClass();
        if (_logger.isDebugEnabled()) {
            _logger.debug((Object)("Looking for state transition handler for frame " + clazz));
        }
        if ((classToHandlerMap = (Map)this._state2HandlersMap.get(currentState)) == null) {
            return this.findStateTransitionHandler(null, frame);
        }
        StateAwareMethodListener handler = (StateAwareMethodListener)classToHandlerMap.get(clazz);
        if (handler == null) {
            if (currentState == null) {
                _logger.debug((Object)("No state transition handler defined for receiving frame " + frame));
                return null;
            }
            return this.findStateTransitionHandler(null, frame);
        }
        return handler;
    }

    public void addStateListener(StateListener listener) {
        _logger.debug((Object)"Adding state listener");
        this._stateListeners.add(listener);
    }

    public void removeStateListener(StateListener listener) {
        this._stateListeners.remove(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void attainState(AMQState s) throws AMQException {
        boolean needToWait = false;
        StateWaiter sw = null;
        CopyOnWriteArraySet copyOnWriteArraySet = this._stateListeners;
        synchronized (copyOnWriteArraySet) {
            if (this._currentState != s) {
                _logger.debug((Object)("Adding state wait to reach state " + s));
                sw = new StateWaiter(s);
                this.addStateListener(sw);
                needToWait = true;
            }
        }
        if (needToWait) {
            sw.waituntilStateHasChanged();
        }
    }
}

