/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.client.state;

import org.apache.log4j.Logger;
import org.apache.qpid.AMQException;
import org.apache.qpid.client.state.AMQState;
import org.apache.qpid.client.state.StateListener;

public class StateWaiter
implements StateListener {
    private static final Logger _logger = Logger.getLogger(StateWaiter.class);
    private final AMQState _state;
    private volatile boolean _newStateAchieved;
    private volatile Throwable _throwable;
    private final Object _monitor = new Object();

    public StateWaiter(AMQState state) {
        this._state = state;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waituntilStateHasChanged() throws AMQException {
        Object object = this._monitor;
        synchronized (object) {
            while (!this._newStateAchieved && this._throwable == null) {
                try {
                    _logger.debug((Object)("State " + this._state + " not achieved so waiting..."));
                    this._monitor.wait();
                }
                catch (InterruptedException e) {
                    _logger.debug((Object)("Interrupted exception caught while waiting: " + e), (Throwable)e);
                }
            }
        }
        if (this._throwable != null) {
            _logger.debug((Object)("Throwable reached state waiter: " + this._throwable));
            if (this._throwable instanceof AMQException) {
                throw (AMQException)this._throwable;
            }
            throw new AMQException("Error: " + this._throwable, this._throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stateChanged(AMQState oldState, AMQState newState) {
        Object object = this._monitor;
        synchronized (object) {
            if (_logger.isDebugEnabled()) {
                _logger.debug((Object)"stateChanged called");
            }
            if (this._state == newState) {
                this._newStateAchieved = true;
                if (_logger.isDebugEnabled()) {
                    _logger.debug((Object)"New state reached so notifying monitor");
                }
                this._monitor.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void error(Throwable t) {
        Object object = this._monitor;
        synchronized (object) {
            if (_logger.isDebugEnabled()) {
                _logger.debug((Object)"exceptionThrown called");
            }
            this._throwable = t;
            this._monitor.notifyAll();
        }
    }
}

