/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.client.transport;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import org.apache.log4j.Logger;
import org.apache.mina.common.ByteBuffer;
import org.apache.mina.common.ByteBufferAllocator;
import org.apache.mina.common.ConnectFuture;
import org.apache.mina.common.IoConnector;
import org.apache.mina.common.IoHandler;
import org.apache.mina.common.SimpleByteBufferAllocator;
import org.apache.mina.common.ThreadModel;
import org.apache.mina.transport.socket.nio.SocketConnectorConfig;
import org.apache.mina.transport.socket.nio.SocketSessionConfig;
import org.apache.qpid.client.protocol.AMQProtocolHandler;
import org.apache.qpid.client.transport.ITransportConnection;
import org.apache.qpid.jms.BrokerDetails;
import org.apache.qpid.pool.ReadWriteThreadModel;

public class SocketTransportConnection
implements ITransportConnection {
    private static final Logger _logger = Logger.getLogger(SocketTransportConnection.class);
    private static final int DEFAULT_BUFFER_SIZE = 32768;
    private SocketConnectorFactory _socketConnectorFactory;

    public SocketTransportConnection(SocketConnectorFactory socketConnectorFactory) {
        this._socketConnectorFactory = socketConnectorFactory;
    }

    public void connect(AMQProtocolHandler protocolHandler, BrokerDetails brokerDetail) throws IOException {
        ByteBuffer.setUseDirectBuffers((boolean)Boolean.getBoolean("amqj.enableDirectBuffers"));
        if (!Boolean.getBoolean("amqj.enablePooledAllocator")) {
            ByteBuffer.setAllocator((ByteBufferAllocator)new SimpleByteBufferAllocator());
        }
        IoConnector ioConnector = this._socketConnectorFactory.newSocketConnector();
        SocketConnectorConfig cfg = (SocketConnectorConfig)ioConnector.getDefaultConfig();
        boolean readWriteThreading = Boolean.getBoolean("amqj.shared_read_write_pool");
        if (readWriteThreading) {
            cfg.setThreadModel((ThreadModel)new ReadWriteThreadModel());
        }
        SocketSessionConfig scfg = (SocketSessionConfig)cfg.getSessionConfig();
        scfg.setTcpNoDelay("true".equalsIgnoreCase(System.getProperty("amqj.tcpNoDelay", "true")));
        scfg.setSendBufferSize(Integer.getInteger("amqj.sendBufferSize", 32768).intValue());
        _logger.info((Object)("send-buffer-size = " + scfg.getSendBufferSize()));
        scfg.setReceiveBufferSize(Integer.getInteger("amqj.receiveBufferSize", 32768).intValue());
        _logger.info((Object)("recv-buffer-size = " + scfg.getReceiveBufferSize()));
        InetSocketAddress address = new InetSocketAddress(brokerDetail.getHost(), brokerDetail.getPort());
        protocolHandler.setUseSSL(brokerDetail.useSSL());
        _logger.info((Object)("Attempting connection to " + address));
        ConnectFuture future = ioConnector.connect((SocketAddress)address, (IoHandler)protocolHandler);
        if (!future.join(brokerDetail.getTimeout())) {
            throw new IOException("Timeout waiting for connection.");
        }
        future.getSession();
    }

    static interface SocketConnectorFactory {
        public IoConnector newSocketConnector();
    }
}

