/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.client.transport;

import java.io.IOException;
import java.net.SocketAddress;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.log4j.Logger;
import org.apache.mina.common.IoConnector;
import org.apache.mina.common.IoHandler;
import org.apache.mina.common.IoHandlerAdapter;
import org.apache.mina.common.IoServiceConfig;
import org.apache.mina.common.ThreadModel;
import org.apache.mina.transport.socket.nio.SocketConnector;
import org.apache.mina.transport.vmpipe.VmPipeAcceptor;
import org.apache.mina.transport.vmpipe.VmPipeAddress;
import org.apache.qpid.client.AMQBrokerDetails;
import org.apache.qpid.client.transport.AMQNoTransportForProtocolException;
import org.apache.qpid.client.transport.AMQTransportConnectionException;
import org.apache.qpid.client.transport.ITransportConnection;
import org.apache.qpid.client.transport.SocketTransportConnection;
import org.apache.qpid.client.transport.VmPipeTransportConnection;
import org.apache.qpid.client.vmbroker.AMQVMBrokerCreationException;
import org.apache.qpid.jms.BrokerDetails;
import org.apache.qpid.pool.ReadWriteThreadModel;

public class TransportConnection {
    private static ITransportConnection _instance;
    private static Map _inVmPipeAddress;
    private static VmPipeAcceptor _acceptor;
    private static int _currentInstance;
    private static int _currentVMPort;
    private static final int TCP = 0;
    private static final int VM = 1;
    private static Logger _logger;
    private static final String DEFAULT_QPID_SERVER = "org.apache.qpid.server.protocol.AMQPFastProtocolHandler";

    public static ITransportConnection getInstance() throws AMQTransportConnectionException {
        AMQBrokerDetails details = new AMQBrokerDetails();
        details.setTransport("tcp");
        return TransportConnection.getInstance(details);
    }

    public static ITransportConnection getInstance(BrokerDetails details) throws AMQTransportConnectionException {
        int transport = TransportConnection.getTransport(details.getTransport());
        if (transport == -1) {
            throw new AMQNoTransportForProtocolException(details);
        }
        if (transport == _currentInstance) {
            if (transport == 1) {
                if (_currentVMPort == details.getPort()) {
                    return _instance;
                }
            } else {
                return _instance;
            }
        }
        _currentInstance = transport;
        switch (transport) {
            case 0: {
                _instance = new SocketTransportConnection(new SocketTransportConnection.SocketConnectorFactory(){

                    public IoConnector newSocketConnector() {
                        if (Boolean.getBoolean("qpidnio")) {
                            _logger.warn((Object)"Using Qpid NIO - DISABLED");
                        }
                        _logger.warn((Object)"Using Mina NIO");
                        SocketConnector result = new SocketConnector();
                        result.setWorkerTimeout(0);
                        return result;
                    }
                });
                break;
            }
            case 1: {
                _instance = TransportConnection.getVMTransport(details, Boolean.getBoolean("amqj.AutoCreateVMBroker"));
            }
        }
        return _instance;
    }

    private static int getTransport(String transport) {
        if (transport.equals("tcp")) {
            return 0;
        }
        if (transport.equals("vm")) {
            return 1;
        }
        return -1;
    }

    private static ITransportConnection getVMTransport(BrokerDetails details, boolean AutoCreate) throws AMQVMBrokerCreationException {
        int port = details.getPort();
        if (!_inVmPipeAddress.containsKey(port)) {
            if (AutoCreate) {
                TransportConnection.createVMBroker(port);
            } else {
                throw new AMQVMBrokerCreationException(port, "VM Broker on port " + port + " does not exist. Auto create disabled.");
            }
        }
        return new VmPipeTransportConnection(port);
    }

    public static void createVMBroker(int port) throws AMQVMBrokerCreationException {
        if (!_inVmPipeAddress.containsKey(port)) {
            _logger.info((Object)("Creating InVM Qpid.AMQP listening on port " + port));
            IoHandlerAdapter provider = null;
            try {
                VmPipeAddress pipe = new VmPipeAddress(port);
                provider = TransportConnection.createBrokerInstance(port);
                _acceptor.bind((SocketAddress)pipe, (IoHandler)provider);
                _inVmPipeAddress.put(port, pipe);
                _logger.info((Object)("Created InVM Qpid.AMQP listening on port " + port));
            }
            catch (IOException e) {
                _logger.error((Object)e);
                try {
                    VmPipeAddress pipe = new VmPipeAddress(port);
                    try {
                        _acceptor.unbind((SocketAddress)pipe);
                    }
                    catch (Exception ignore) {
                        // empty catch block
                    }
                    if (provider == null) {
                        provider = TransportConnection.createBrokerInstance(port);
                    }
                    _acceptor.bind((SocketAddress)pipe, (IoHandler)provider);
                    _inVmPipeAddress.put(port, pipe);
                    _logger.info((Object)("Created InVM Qpid.AMQP listening on port " + port));
                }
                catch (IOException justUseFirstException) {
                    String because = e.getCause() == null ? e.toString() : e.getCause().toString();
                    throw new AMQVMBrokerCreationException(port, because + " Stopped binding of InVM Qpid.AMQP");
                }
            }
        } else {
            _logger.info((Object)("InVM Qpid.AMQP on port " + port + " already exits."));
        }
    }

    private static IoHandlerAdapter createBrokerInstance(int port) throws AMQVMBrokerCreationException {
        IoHandlerAdapter provider;
        String protocolProviderClass = System.getProperty("amqj.protocolprovider.class", DEFAULT_QPID_SERVER);
        _logger.info((Object)("Creating Qpid protocol provider: " + protocolProviderClass));
        try {
            Class[] cnstr = new Class[]{Integer.class};
            Object[] params = new Object[]{port};
            provider = (IoHandlerAdapter)Class.forName(protocolProviderClass).getConstructor(cnstr).newInstance(params);
            _logger.info((Object)"Created Instance");
        }
        catch (Exception e) {
            _logger.info((Object)("Unable to create InVM Qpid.AMQP on port " + port + ". Because: " + e.getCause()));
            _logger.error((Object)e);
            String because = e.getCause() == null ? e.toString() : e.getCause().toString();
            throw new AMQVMBrokerCreationException(port, because + " Stopped InVM Qpid.AMQP creation");
        }
        return provider;
    }

    public static void killAllVMBrokers() {
        _logger.info((Object)"Killing all VM Brokers");
        _acceptor.unbindAll();
        Iterator keys = _inVmPipeAddress.keySet().iterator();
        while (keys.hasNext()) {
            int id = (Integer)keys.next();
            _inVmPipeAddress.remove(id);
        }
    }

    public static void killVMBroker(int port) {
        VmPipeAddress pipe = (VmPipeAddress)_inVmPipeAddress.get(port);
        if (pipe != null) {
            _logger.info((Object)("Killing VM Broker:" + port));
            _inVmPipeAddress.remove(port);
            _acceptor.unbind((SocketAddress)pipe);
        }
    }

    static {
        _inVmPipeAddress = new HashMap();
        _currentInstance = -1;
        _currentVMPort = -1;
        _logger = Logger.getLogger(TransportConnection.class);
        _acceptor = new VmPipeAcceptor();
        IoServiceConfig config = _acceptor.getDefaultConfig();
        config.setThreadModel((ThreadModel)new ReadWriteThreadModel());
    }
}

