/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.client.transport;

import java.io.IOException;
import java.net.SocketAddress;
import org.apache.log4j.Logger;
import org.apache.mina.common.ConnectFuture;
import org.apache.mina.common.IoFilter;
import org.apache.mina.common.IoHandler;
import org.apache.mina.common.IoServiceConfig;
import org.apache.mina.transport.vmpipe.VmPipeAddress;
import org.apache.mina.transport.vmpipe.VmPipeConnector;
import org.apache.qpid.client.protocol.AMQProtocolHandler;
import org.apache.qpid.client.transport.ITransportConnection;
import org.apache.qpid.jms.BrokerDetails;
import org.apache.qpid.pool.PoolingFilter;
import org.apache.qpid.pool.ReferenceCountingExecutorService;

public class VmPipeTransportConnection
implements ITransportConnection {
    private static final Logger _logger = Logger.getLogger(VmPipeTransportConnection.class);
    private static int _port;

    public VmPipeTransportConnection(int port) {
        _port = port;
    }

    public void connect(AMQProtocolHandler protocolHandler, BrokerDetails brokerDetail) throws IOException {
        VmPipeConnector ioConnector = new VmPipeConnector();
        IoServiceConfig cfg = ioConnector.getDefaultConfig();
        ReferenceCountingExecutorService executorService = ReferenceCountingExecutorService.getInstance();
        PoolingFilter asyncRead = new PoolingFilter(executorService, PoolingFilter.READ_EVENTS, "AsynchronousReadFilter");
        cfg.getFilterChain().addFirst("AsynchronousReadFilter", (IoFilter)asyncRead);
        PoolingFilter asyncWrite = new PoolingFilter(executorService, PoolingFilter.WRITE_EVENTS, "AsynchronousWriteFilter");
        cfg.getFilterChain().addLast("AsynchronousWriteFilter", (IoFilter)asyncWrite);
        VmPipeAddress address = new VmPipeAddress(_port);
        _logger.info((Object)("Attempting connection to " + address));
        ConnectFuture future = ioConnector.connect((SocketAddress)address, (IoHandler)protocolHandler);
        future.join();
        future.getSession();
    }
}

