/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.client.util;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;

public class FlowControllingBlockingQueue {
    private final BlockingQueue _queue = new LinkedBlockingQueue();
    private final int _flowControlHighThreshold;
    private final int _flowControlLowThreshold;
    private final ThresholdListener _listener;
    private int _count;

    public FlowControllingBlockingQueue(int threshold, ThresholdListener listener) {
        this(threshold, threshold, listener);
    }

    public FlowControllingBlockingQueue(int highThreshold, int lowThreshold, ThresholdListener listener) {
        this._flowControlHighThreshold = highThreshold;
        this._flowControlLowThreshold = lowThreshold;
        this._listener = listener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object take() throws InterruptedException {
        Object o = this._queue.take();
        if (this._listener != null) {
            ThresholdListener thresholdListener = this._listener;
            synchronized (thresholdListener) {
                if (this._count-- == this._flowControlLowThreshold) {
                    this._listener.underThreshold(this._count);
                }
            }
        }
        return o;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(Object o) {
        this._queue.add(o);
        if (this._listener != null) {
            ThresholdListener thresholdListener = this._listener;
            synchronized (thresholdListener) {
                if (++this._count == this._flowControlHighThreshold) {
                    this._listener.aboveThreshold(this._count);
                }
            }
        }
    }

    public static interface ThresholdListener {
        public void aboveThreshold(int var1);

        public void underThreshold(int var1);
    }
}

