/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.jms.failover;

import org.apache.log4j.Logger;
import org.apache.qpid.jms.BrokerDetails;
import org.apache.qpid.jms.ConnectionURL;
import org.apache.qpid.jms.failover.FailoverMethod;

public class FailoverRoundRobinServers
implements FailoverMethod {
    private static final Logger _logger = Logger.getLogger(FailoverRoundRobinServers.class);
    public static final int DEFAULT_CYCLE_RETRIES = 0;
    public static final int DEFAULT_SERVER_RETRIES = 0;
    private int _currentBrokerIndex = -1;
    private int _serverRetries;
    private int _currentServerRetry;
    private int _cycleRetries;
    private int _currentCycleRetries;
    private ConnectionURL _connectionDetails;

    public FailoverRoundRobinServers(ConnectionURL connectionDetails) {
        if (connectionDetails.getBrokerCount() <= 0) {
            throw new IllegalArgumentException("At least one broker details must be specified.");
        }
        this._connectionDetails = connectionDetails;
        this._currentBrokerIndex = -1;
        String cycleRetries = this._connectionDetails.getFailoverOption("cyclecount");
        if (cycleRetries != null) {
            try {
                this._cycleRetries = Integer.parseInt(cycleRetries);
            }
            catch (NumberFormatException nfe) {
                this._cycleRetries = 0;
            }
        }
        this._currentCycleRetries = 0;
        this._serverRetries = 0;
        this._currentServerRetry = -1;
    }

    public void reset() {
        this._currentBrokerIndex = 0;
        this._currentCycleRetries = 0;
        this._currentServerRetry = -1;
    }

    public boolean failoverAllowed() {
        return this._currentCycleRetries < this._cycleRetries || this._currentServerRetry < this._serverRetries || this._currentBrokerIndex < this._connectionDetails.getBrokerCount() - 1;
    }

    public void attainedConnection() {
        this._currentCycleRetries = 0;
        this._currentServerRetry = -1;
    }

    public BrokerDetails getCurrentBrokerDetails() {
        if (this._currentBrokerIndex == -1) {
            return null;
        }
        return this._connectionDetails.getBrokerDetails(this._currentBrokerIndex);
    }

    public BrokerDetails getNextBrokerDetails() {
        if (this._currentBrokerIndex == this._connectionDetails.getBrokerCount() - 1) {
            if (this._currentServerRetry < this._serverRetries) {
                if (this._currentBrokerIndex == -1) {
                    this._currentBrokerIndex = 0;
                    this.setBroker(this._connectionDetails.getBrokerDetails(this._currentBrokerIndex));
                    _logger.info((Object)("First run using " + this._connectionDetails.getBrokerDetails(this._currentBrokerIndex)));
                } else {
                    _logger.info((Object)("Retrying " + this._connectionDetails.getBrokerDetails(this._currentBrokerIndex)));
                }
                ++this._currentServerRetry;
            } else {
                ++this._currentCycleRetries;
                this._currentBrokerIndex = 0;
                this.setBroker(this._connectionDetails.getBrokerDetails(this._currentBrokerIndex));
                this._currentServerRetry = 0;
            }
        } else if (this._currentServerRetry < this._serverRetries) {
            if (this._currentBrokerIndex == -1) {
                this._currentBrokerIndex = 0;
                this.setBroker(this._connectionDetails.getBrokerDetails(this._currentBrokerIndex));
                _logger.info((Object)("First run using " + this._connectionDetails.getBrokerDetails(this._currentBrokerIndex)));
            } else {
                _logger.info((Object)("Retrying " + this._connectionDetails.getBrokerDetails(this._currentBrokerIndex)));
            }
            ++this._currentServerRetry;
        } else {
            ++this._currentBrokerIndex;
            this.setBroker(this._connectionDetails.getBrokerDetails(this._currentBrokerIndex));
            this._currentServerRetry = 0;
        }
        return this._connectionDetails.getBrokerDetails(this._currentBrokerIndex);
    }

    public void setBroker(BrokerDetails broker) {
        this._connectionDetails.addBrokerDetails(broker);
        int index = this._connectionDetails.getAllBrokerDetails().indexOf(broker);
        String serverRetries = broker.getOption("retries");
        if (serverRetries != null) {
            try {
                this._serverRetries = Integer.parseInt(serverRetries);
            }
            catch (NumberFormatException nfe) {
                this._serverRetries = 0;
            }
        }
        this._currentServerRetry = -1;
        this._currentBrokerIndex = index;
    }

    public void setRetries(int maxRetries) {
        this._cycleRetries = maxRetries;
    }

    public String methodName() {
        return "Cycle Servers";
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("Cycle Servers:\n");
        sb.append("Cycle Retries:");
        sb.append(this._cycleRetries);
        sb.append("\nCurrent Cycle:");
        sb.append(this._currentCycleRetries);
        sb.append("\nServer Retries:");
        sb.append(this._serverRetries);
        sb.append("\nCurrent Retry:");
        sb.append(this._currentServerRetry);
        sb.append("\nCurrent Broker:");
        sb.append(this._currentBrokerIndex);
        sb.append("\n");
        for (int i = 0; i < this._connectionDetails.getBrokerCount(); ++i) {
            if (i == this._currentBrokerIndex) {
                sb.append(">");
            }
            sb.append(this._connectionDetails.getBrokerDetails(i));
            sb.append("\n");
        }
        return sb.toString();
    }
}

