/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.jms.failover;

import org.apache.qpid.jms.BrokerDetails;
import org.apache.qpid.jms.ConnectionURL;
import org.apache.qpid.jms.failover.FailoverMethod;

public class FailoverSingleServer
implements FailoverMethod {
    public static final int DEFAULT_SERVER_RETRIES = 1;
    private BrokerDetails _brokerDetail;
    private int _retries;
    private int _currentRetries;

    public FailoverSingleServer(ConnectionURL connectionDetails) {
        if (connectionDetails.getBrokerCount() <= 0) {
            throw new IllegalArgumentException("BrokerDetails details required for connection.");
        }
        this.setBroker(connectionDetails.getBrokerDetails(0));
    }

    public FailoverSingleServer(BrokerDetails brokerDetail) {
        this.setBroker(brokerDetail);
    }

    public void reset() {
        this._currentRetries = -1;
    }

    public boolean failoverAllowed() {
        return this._currentRetries < this._retries;
    }

    public void attainedConnection() {
        this.reset();
    }

    public BrokerDetails getCurrentBrokerDetails() {
        return this._brokerDetail;
    }

    public BrokerDetails getNextBrokerDetails() {
        if (this._currentRetries == this._retries) {
            return null;
        }
        if (this._currentRetries < this._retries) {
            ++this._currentRetries;
        }
        return this._brokerDetail;
    }

    public void setBroker(BrokerDetails broker) {
        if (broker == null) {
            throw new IllegalArgumentException("BrokerDetails details cannot be null");
        }
        this._brokerDetail = broker;
        String retries = broker.getOption("retries");
        if (retries != null) {
            try {
                this._retries = Integer.parseInt(retries);
            }
            catch (NumberFormatException nfe) {
                this._retries = 1;
            }
        } else {
            this._retries = 1;
        }
        this.reset();
    }

    public void setRetries(int retries) {
        this._retries = retries;
    }

    public String methodName() {
        return "Single Server";
    }

    public String toString() {
        return "SingleServer:\nMax Retries:" + this._retries + "\nCurrent Retry:" + this._currentRetries + "\n" + this._brokerDetail + "\n";
    }
}

