/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.jndi;

import java.util.Hashtable;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.Queue;
import javax.jms.Topic;
import javax.naming.Context;
import javax.naming.NamingException;
import javax.naming.spi.InitialContextFactory;
import org.apache.log4j.Logger;
import org.apache.qpid.client.AMQConnectionFactory;
import org.apache.qpid.client.AMQHeadersExchange;
import org.apache.qpid.client.AMQQueue;
import org.apache.qpid.client.AMQTopic;
import org.apache.qpid.jndi.ReadOnlyContext;
import org.apache.qpid.url.AMQBindingURL;
import org.apache.qpid.url.BindingURL;
import org.apache.qpid.url.URLSyntaxException;

public class PropertiesFileInitialContextFactory
implements InitialContextFactory {
    protected final Logger _logger = Logger.getLogger(this.getClass());
    private String CONNECTION_FACTORY_PREFIX = "connectionfactory.";
    private String DESTINATION_PREFIX = "destination.";
    private String QUEUE_PREFIX = "queue.";
    private String TOPIC_PREFIX = "topic.";

    public Context getInitialContext(Hashtable environment) throws NamingException {
        ConcurrentHashMap data = new ConcurrentHashMap();
        this.createConnectionFactories(data, environment);
        this.createDestinations(data, environment);
        this.createQueues(data, environment);
        this.createTopics(data, environment);
        return this.createContext(data, environment);
    }

    protected ReadOnlyContext createContext(Map data, Hashtable environment) {
        return new ReadOnlyContext(environment, data);
    }

    protected void createConnectionFactories(Map data, Hashtable environment) {
        for (Map.Entry entry : environment.entrySet()) {
            String key = entry.getKey().toString();
            if (!key.startsWith(this.CONNECTION_FACTORY_PREFIX)) continue;
            String jndiName = key.substring(this.CONNECTION_FACTORY_PREFIX.length());
            ConnectionFactory cf = this.createFactory(entry.getValue().toString());
            if (cf == null) continue;
            data.put(jndiName, cf);
        }
    }

    protected void createDestinations(Map data, Hashtable environment) {
        for (Map.Entry entry : environment.entrySet()) {
            String key = entry.getKey().toString();
            if (!key.startsWith(this.DESTINATION_PREFIX)) continue;
            String jndiName = key.substring(this.DESTINATION_PREFIX.length());
            Destination dest = this.createDestination(entry.getValue().toString());
            if (dest == null) continue;
            data.put(jndiName, dest);
        }
    }

    protected void createQueues(Map data, Hashtable environment) {
        for (Map.Entry entry : environment.entrySet()) {
            String key = entry.getKey().toString();
            if (!key.startsWith(this.QUEUE_PREFIX)) continue;
            String jndiName = key.substring(this.QUEUE_PREFIX.length());
            Queue q = this.createQueue(entry.getValue().toString());
            if (q == null) continue;
            data.put(jndiName, q);
        }
    }

    protected void createTopics(Map data, Hashtable environment) {
        for (Map.Entry entry : environment.entrySet()) {
            String key = entry.getKey().toString();
            if (!key.startsWith(this.TOPIC_PREFIX)) continue;
            String jndiName = key.substring(this.TOPIC_PREFIX.length());
            Topic t = this.createTopic(entry.getValue().toString());
            if (t == null) continue;
            data.put(jndiName, t);
        }
    }

    protected ConnectionFactory createFactory(String url) {
        try {
            return new AMQConnectionFactory(url);
        }
        catch (URLSyntaxException urlse) {
            this._logger.warn((Object)("Unable to createFactories:" + (Object)((Object)urlse)));
            return null;
        }
    }

    protected Destination createDestination(String bindingURL) {
        AMQBindingURL binding;
        try {
            binding = new AMQBindingURL(bindingURL);
        }
        catch (URLSyntaxException urlse) {
            this._logger.warn((Object)("Unable to destination:" + (Object)((Object)urlse)));
            return null;
        }
        if (binding.getExchangeClass().equals("topic")) {
            return this.createTopic(binding);
        }
        if (binding.getExchangeClass().equals("direct")) {
            return this.createQueue(binding);
        }
        if (binding.getExchangeClass().equals("headers")) {
            return this.createHeaderExchange(binding);
        }
        this._logger.warn((Object)("Binding: '" + binding + "' not supported"));
        return null;
    }

    protected Queue createQueue(Object value) {
        if (value instanceof String) {
            return new AMQQueue((String)value);
        }
        if (value instanceof BindingURL) {
            return new AMQQueue((BindingURL)value);
        }
        return null;
    }

    protected Topic createTopic(Object value) {
        if (value instanceof String) {
            return new AMQTopic((String)value);
        }
        if (value instanceof BindingURL) {
            return new AMQTopic((BindingURL)value);
        }
        return null;
    }

    protected Destination createHeaderExchange(Object value) {
        if (value instanceof String) {
            return new AMQHeadersExchange((String)value);
        }
        if (value instanceof BindingURL) {
            return new AMQHeadersExchange((BindingURL)value);
        }
        return null;
    }

    public String getConnectionPrefix() {
        return this.CONNECTION_FACTORY_PREFIX;
    }

    public void setConnectionPrefix(String connectionPrefix) {
        this.CONNECTION_FACTORY_PREFIX = connectionPrefix;
    }

    public String getDestinationPrefix() {
        return this.DESTINATION_PREFIX;
    }

    public void setDestinationPrefix(String destinationPrefix) {
        this.DESTINATION_PREFIX = destinationPrefix;
    }

    public String getQueuePrefix() {
        return this.QUEUE_PREFIX;
    }

    public void setQueuePrefix(String queuePrefix) {
        this.QUEUE_PREFIX = queuePrefix;
    }

    public String getTopicPrefix() {
        return this.TOPIC_PREFIX;
    }

    public void setTopicPrefix(String topicPrefix) {
        this.TOPIC_PREFIX = topicPrefix;
    }
}

