/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.gogrid.binders;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.primitives.Longs;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.inject.Singleton;
import javax.ws.rs.core.UriBuilder;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.utils.ModifyRequest;
import org.jclouds.rest.Binder;

@Singleton
public class BindIdsToQueryParams
implements Binder {
    private final Provider<UriBuilder> builder;

    @Inject
    BindIdsToQueryParams(Provider<UriBuilder> builder) {
        this.builder = builder;
    }

    public <R extends HttpRequest> R bindToRequest(R request, Object input) {
        if (Preconditions.checkNotNull((Object)input, (Object)"input is null") instanceof Long[]) {
            Object[] names = (Long[])input;
            request = ModifyRequest.addQueryParam(request, (String)"id", (Iterable)ImmutableList.copyOf((Object[])names), (UriBuilder)((UriBuilder)this.builder.get()));
        } else if (input instanceof long[]) {
            long[] names = (long[])input;
            request = ModifyRequest.addQueryParam(request, (String)"id", (Iterable)Longs.asList((long[])names), (UriBuilder)((UriBuilder)this.builder.get()));
        } else {
            throw new IllegalArgumentException("this binder is only valid for Long[] arguments: " + input.getClass());
        }
        return request;
    }
}

