/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.gogrid.compute.functions;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.annotation.Resource;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.collect.Memoized;
import org.jclouds.compute.domain.Hardware;
import org.jclouds.compute.domain.Image;
import org.jclouds.compute.domain.NodeMetadata;
import org.jclouds.compute.domain.NodeMetadataBuilder;
import org.jclouds.compute.domain.NodeState;
import org.jclouds.compute.util.ComputeServiceUtils;
import org.jclouds.domain.Location;
import org.jclouds.gogrid.domain.Server;
import org.jclouds.gogrid.domain.ServerState;
import org.jclouds.location.predicates.LocationPredicates;
import org.jclouds.logging.Logger;

@Singleton
public class ServerToNodeMetadata
implements Function<Server, NodeMetadata> {
    @Resource
    protected Logger logger = Logger.NULL;
    private final Map<ServerState, NodeState> serverStateToNodeState;
    private final Supplier<Set<? extends Image>> images;
    private final Supplier<Set<? extends Hardware>> hardwares;
    private final Supplier<Set<? extends Location>> locations;

    @Inject
    ServerToNodeMetadata(Map<ServerState, NodeState> serverStateToNodeState, @Memoized Supplier<Set<? extends Image>> images, @Memoized Supplier<Set<? extends Hardware>> hardwares, @Memoized Supplier<Set<? extends Location>> locations) {
        this.serverStateToNodeState = (Map)Preconditions.checkNotNull(serverStateToNodeState, (Object)"serverStateToNodeState");
        this.images = (Supplier)Preconditions.checkNotNull(images, (Object)"images");
        this.hardwares = (Supplier)Preconditions.checkNotNull(hardwares, (Object)"hardwares");
        this.locations = (Supplier)Preconditions.checkNotNull(locations, (Object)"locations");
    }

    public NodeMetadata apply(Server from) {
        NodeMetadataBuilder builder = new NodeMetadataBuilder();
        builder.ids(from.getId() + "");
        builder.name(from.getName());
        Location location = (Location)Iterables.find((Iterable)((Iterable)this.locations.get()), (Predicate)LocationPredicates.idEquals((String)(from.getDatacenter().getId() + "")));
        builder.location(location);
        builder.group(ComputeServiceUtils.parseGroupFromName((String)from.getName()));
        builder.hardware(this.parseHardware(from));
        builder.imageId(from.getImage().getId() + "");
        Image image = this.parseImage(from);
        if (image != null) {
            builder.operatingSystem(image.getOperatingSystem());
        }
        builder.state(this.serverStateToNodeState.get((Object)from.getState()));
        builder.publicAddresses((Iterable)ImmutableSet.of((Object)from.getIp().getIp()));
        return builder.build();
    }

    protected Image parseImage(Server from) {
        Image image = null;
        try {
            image = (Image)Iterables.find((Iterable)((Iterable)this.images.get()), (Predicate)new FindImageForServer(from));
        }
        catch (NoSuchElementException e) {
            this.logger.warn("could not find a matching image for server %s", new Object[]{from});
        }
        return image;
    }

    protected Hardware parseHardware(Server from) {
        Hardware hardware = null;
        try {
            hardware = (Hardware)Iterables.find((Iterable)((Iterable)this.hardwares.get()), (Predicate)new FindHardwareForServer(from));
        }
        catch (NoSuchElementException e) {
            this.logger.warn("could not find a matching hardware for server %s", new Object[]{from});
        }
        return hardware;
    }

    static class FindHardwareForServer
    implements Predicate<Hardware> {
        private final Server instance;

        @Inject
        private FindHardwareForServer(Server instance) {
            this.instance = instance;
        }

        public boolean apply(Hardware input) {
            return input.getRam() == Integer.parseInt(this.instance.getRam().getName().replaceAll("[^0-9]", ""));
        }
    }

    static class FindImageForServer
    implements Predicate<Image> {
        private final Server instance;

        @Inject
        private FindImageForServer(Server instance) {
            this.instance = instance;
        }

        public boolean apply(Image input) {
            return input.getProviderId().equals(this.instance.getImage().getId() + "") && (input.getLocation() == null || input.getLocation().getId().equals(this.instance.getDatacenter().getId() + ""));
        }
    }
}

