/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.gogrid.domain;

import com.google.common.primitives.Longs;

public class BillingToken
implements Comparable<BillingToken> {
    private long id;
    private String name;
    private double price;

    public BillingToken() {
    }

    public BillingToken(long id, String name, double price) {
        this.id = id;
        this.name = name;
        this.price = price;
    }

    public long getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public double getPrice() {
        return this.price;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BillingToken other = (BillingToken)obj;
        if (this.id != other.id) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        return Double.doubleToLongBits(this.price) == Double.doubleToLongBits(other.price);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (int)(this.id ^ this.id >>> 32);
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        long temp = Double.doubleToLongBits(this.price);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    @Override
    public int compareTo(BillingToken o) {
        return Longs.compare((long)this.id, (long)o.getId());
    }

    public String toString() {
        return "BillingToken{id=" + this.id + ", name='" + this.name + '\'' + ", price=" + this.price + '}';
    }
}

