/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.gogrid.domain;

import com.google.common.primitives.Longs;
import org.jclouds.gogrid.domain.Ip;
import org.jclouds.gogrid.domain.Option;
import org.jclouds.gogrid.domain.ServerImage;
import org.jclouds.gogrid.domain.ServerState;

public class Server
implements Comparable<Server> {
    private long id;
    private boolean isSandbox;
    private String name;
    private String description;
    private ServerState state;
    private Option datacenter;
    private Option type;
    private Option ram;
    private Option os;
    private Ip ip;
    private ServerImage image;

    Server() {
    }

    public Server(long id, Option datacenter, boolean sandbox, String name, String description, ServerState state, Option type, Option ram, Option os, Ip ip, ServerImage image) {
        this.id = id;
        this.isSandbox = sandbox;
        this.name = name;
        this.description = description;
        this.state = state;
        this.type = type;
        this.ram = ram;
        this.os = os;
        this.ip = ip;
        this.image = image;
        this.datacenter = datacenter;
    }

    public long getId() {
        return this.id;
    }

    public boolean isSandbox() {
        return this.isSandbox;
    }

    public Option getDatacenter() {
        return this.datacenter;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public ServerState getState() {
        return this.state;
    }

    public Option getType() {
        return this.type;
    }

    public Option getRam() {
        return this.ram;
    }

    public Option getOs() {
        return this.os;
    }

    public Ip getIp() {
        return this.ip;
    }

    public ServerImage getImage() {
        return this.image;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Server other = (Server)obj;
        if (this.datacenter == null ? other.datacenter != null : !this.datacenter.equals(other.datacenter)) {
            return false;
        }
        if (this.description == null ? other.description != null : !this.description.equals(other.description)) {
            return false;
        }
        if (this.id != other.id) {
            return false;
        }
        if (this.image == null ? other.image != null : !this.image.equals(other.image)) {
            return false;
        }
        if (this.ip == null ? other.ip != null : !this.ip.equals(other.ip)) {
            return false;
        }
        if (this.isSandbox != other.isSandbox) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        if (this.os == null ? other.os != null : !this.os.equals(other.os)) {
            return false;
        }
        if (this.ram == null ? other.ram != null : !this.ram.equals(other.ram)) {
            return false;
        }
        if (this.state == null ? other.state != null : !this.state.equals((Object)other.state)) {
            return false;
        }
        return !(this.type == null ? other.type != null : !this.type.equals(other.type));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.datacenter == null ? 0 : this.datacenter.hashCode());
        result = 31 * result + (this.description == null ? 0 : this.description.hashCode());
        result = 31 * result + (int)(this.id ^ this.id >>> 32);
        result = 31 * result + (this.image == null ? 0 : this.image.hashCode());
        result = 31 * result + (this.ip == null ? 0 : this.ip.hashCode());
        result = 31 * result + (this.isSandbox ? 1231 : 1237);
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.os == null ? 0 : this.os.hashCode());
        result = 31 * result + (this.ram == null ? 0 : this.ram.hashCode());
        result = 31 * result + (this.state == null ? 0 : this.state.hashCode());
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        return result;
    }

    @Override
    public int compareTo(Server o) {
        return Longs.compare((long)this.id, (long)o.getId());
    }

    public String toString() {
        return "Server [datacenter=" + this.datacenter + ", description=" + this.description + ", id=" + this.id + ", image=" + this.image + ", ip=" + this.ip + ", isSandbox=" + this.isSandbox + ", name=" + this.name + ", os=" + this.os + ", ram=" + this.ram + ", state=" + (Object)((Object)this.state) + ", type=" + this.type + "]";
    }
}

