/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.gogrid.domain;

import com.google.common.primitives.Longs;
import com.google.gson.annotations.SerializedName;
import java.util.Date;
import java.util.Set;
import org.jclouds.gogrid.domain.BillingToken;
import org.jclouds.gogrid.domain.Customer;
import org.jclouds.gogrid.domain.Option;
import org.jclouds.gogrid.domain.ServerImageState;
import org.jclouds.gogrid.domain.ServerImageType;

public class ServerImage
implements Comparable<ServerImage> {
    private long id;
    private String name;
    private String friendlyName;
    private String description;
    private Option os;
    private Option architecture;
    private ServerImageType type;
    private ServerImageState state;
    private double price;
    private String location;
    private boolean isActive;
    private boolean isPublic;
    private Date createdTime;
    private Date updatedTime;
    @SerializedName(value="billingtokens")
    private Set<BillingToken> billingTokens;
    private Customer owner;

    public ServerImage() {
    }

    public ServerImage(long id, String name, String friendlyName, String description, Option os, Option architecture, ServerImageType type, ServerImageState state, double price, String location, boolean active, boolean aPublic, Date createdTime, Date updatedTime, Set<BillingToken> billingTokens, Customer owner) {
        this.id = id;
        this.name = name;
        this.friendlyName = friendlyName;
        this.description = description;
        this.os = os;
        this.architecture = architecture;
        this.type = type;
        this.state = state;
        this.price = price;
        this.location = location;
        this.isActive = active;
        this.isPublic = aPublic;
        this.createdTime = createdTime;
        this.updatedTime = updatedTime;
        this.billingTokens = billingTokens;
        this.owner = owner;
    }

    public long getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getFriendlyName() {
        return this.friendlyName;
    }

    public String getDescription() {
        if (this.description == null) {
            return "";
        }
        return this.description;
    }

    public Option getOs() {
        return this.os;
    }

    public Option getArchitecture() {
        return this.architecture;
    }

    public ServerImageType getType() {
        return this.type;
    }

    public ServerImageState getState() {
        return this.state;
    }

    public double getPrice() {
        return this.price;
    }

    public String getLocation() {
        return this.location;
    }

    public boolean isActive() {
        return this.isActive;
    }

    public boolean isPublic() {
        return this.isPublic;
    }

    public Date getCreatedTime() {
        return this.createdTime;
    }

    public Date getUpdatedTime() {
        return this.updatedTime;
    }

    public Set<BillingToken> getBillingTokens() {
        return this.billingTokens;
    }

    public Customer getOwner() {
        return this.owner;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ServerImage that = (ServerImage)o;
        if (this.id != that.id) {
            return false;
        }
        if (this.isActive != that.isActive) {
            return false;
        }
        if (this.isPublic != that.isPublic) {
            return false;
        }
        if (Double.compare(that.price, this.price) != 0) {
            return false;
        }
        if (this.architecture != null ? !this.architecture.equals(that.architecture) : that.architecture != null) {
            return false;
        }
        if (this.billingTokens != null ? !((Object)this.billingTokens).equals(that.billingTokens) : that.billingTokens != null) {
            return false;
        }
        if (!this.createdTime.equals(that.createdTime)) {
            return false;
        }
        if (this.description != null ? !this.description.equals(that.description) : that.description != null) {
            return false;
        }
        if (this.friendlyName != null ? !this.friendlyName.equals(that.friendlyName) : that.friendlyName != null) {
            return false;
        }
        if (this.location != null ? !this.location.equals(that.location) : that.location != null) {
            return false;
        }
        if (!this.name.equals(that.name)) {
            return false;
        }
        if (!this.os.equals(that.os)) {
            return false;
        }
        if (this.owner != null ? !this.owner.equals(that.owner) : that.owner != null) {
            return false;
        }
        if (!this.state.equals((Object)that.state)) {
            return false;
        }
        if (!this.type.equals((Object)that.type)) {
            return false;
        }
        return !(this.updatedTime != null ? !this.updatedTime.equals(that.updatedTime) : that.updatedTime != null);
    }

    public int hashCode() {
        int result = (int)(this.id ^ this.id >>> 32);
        result = 31 * result + this.name.hashCode();
        result = 31 * result + (this.friendlyName != null ? this.friendlyName.hashCode() : 0);
        result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
        result = 31 * result + this.os.hashCode();
        result = 31 * result + this.type.hashCode();
        result = 31 * result + this.state.hashCode();
        long temp = this.price != 0.0 ? Double.doubleToLongBits(this.price) : 0L;
        result = 31 * result + (int)(temp ^ temp >>> 32);
        result = 31 * result + (this.location != null ? this.location.hashCode() : 0);
        result = 31 * result + (this.isActive ? 1 : 0);
        result = 31 * result + (this.isPublic ? 1 : 0);
        result = 31 * result + this.createdTime.hashCode();
        result = 31 * result + (this.updatedTime != null ? this.updatedTime.hashCode() : 0);
        result = 31 * result + (this.billingTokens != null ? ((Object)this.billingTokens).hashCode() : 0);
        result = 31 * result + (this.owner != null ? this.owner.hashCode() : 0);
        return result;
    }

    @Override
    public int compareTo(ServerImage o) {
        return Longs.compare((long)this.id, (long)o.getId());
    }

    public String toString() {
        return "ServerImage{id=" + this.id + ", name='" + this.name + '\'' + ", friendlyName='" + this.friendlyName + '\'' + ", description='" + this.description + '\'' + ", os=" + this.os + ", architecture=" + this.architecture + ", type=" + (Object)((Object)this.type) + ", state=" + (Object)((Object)this.state) + ", price=" + this.price + ", location='" + this.location + '\'' + ", isActive=" + this.isActive + ", isPublic=" + this.isPublic + ", createdTime=" + this.createdTime + ", updatedTime=" + this.updatedTime + ", billingTokens=" + this.billingTokens + ", owner=" + this.owner + '}';
    }
}

