/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.gogrid.filters;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import com.google.common.io.InputSupplier;
import java.net.URI;
import javax.annotation.Resource;
import javax.inject.Inject;
import javax.inject.Named;
import org.jclouds.crypto.CryptoStreams;
import org.jclouds.date.TimeStamp;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.HttpRequestFilter;
import org.jclouds.http.HttpUtils;
import org.jclouds.http.utils.ModifyRequest;
import org.jclouds.io.InputSuppliers;
import org.jclouds.logging.Logger;

public class SharedKeyLiteAuthentication
implements HttpRequestFilter {
    private final String apiKey;
    private final String secret;
    private final Long timeStamp;
    private final HttpUtils utils;
    @Resource
    @Named(value="jclouds.signature")
    Logger signatureLog = Logger.NULL;

    @Inject
    public SharedKeyLiteAuthentication(@Named(value="jclouds.identity") String apiKey, @Named(value="jclouds.credential") String secret, @TimeStamp Long timeStamp, HttpUtils utils) {
        this.apiKey = apiKey;
        this.secret = secret;
        this.timeStamp = timeStamp;
        this.utils = utils;
    }

    public HttpRequest filter(HttpRequest request) {
        String toSign = this.createStringToSign();
        String signatureMd5 = this.getMd5For(toSign);
        String query = request.getEndpoint().getQuery();
        Multimap decodedParams = ModifyRequest.parseQueryToMap((String)query);
        decodedParams.replaceValues((Object)"sig", (Iterable)ImmutableSet.of((Object)signatureMd5));
        decodedParams.replaceValues((Object)"api_key", (Iterable)ImmutableSet.of((Object)this.apiKey));
        String updatedQuery = ModifyRequest.makeQueryLine((Multimap)decodedParams, null, (char[])new char[0]);
        String requestBasePart = request.getEndpoint().toASCIIString();
        String updatedEndpoint = requestBasePart.substring(0, requestBasePart.indexOf("?") + 1) + updatedQuery;
        request = request.toBuilder().endpoint(URI.create(updatedEndpoint)).build();
        this.utils.logRequest(this.signatureLog, request, "<<");
        return request;
    }

    private String createStringToSign() {
        return String.format("%s%s%s", this.apiKey, this.secret, this.timeStamp);
    }

    private String getMd5For(String stringToHash) {
        try {
            return CryptoStreams.md5Hex((InputSupplier)InputSuppliers.of((String)stringToHash));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

