/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.gogrid.handlers;

import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import java.util.Set;
import org.jclouds.gogrid.GoGridResponseException;
import org.jclouds.gogrid.domain.internal.ErrorResponse;
import org.jclouds.gogrid.functions.ParseErrorFromJsonResponse;
import org.jclouds.http.HttpCommand;
import org.jclouds.http.HttpErrorHandler;
import org.jclouds.http.HttpMessage;
import org.jclouds.http.HttpResponse;
import org.jclouds.http.HttpResponseException;
import org.jclouds.http.HttpUtils;
import org.jclouds.rest.AuthorizationException;
import org.jclouds.rest.ResourceNotFoundException;

public class GoGridErrorHandler
implements HttpErrorHandler {
    private final ParseErrorFromJsonResponse errorParser;

    @Inject
    public GoGridErrorHandler(ParseErrorFromJsonResponse errorParser) {
        this.errorParser = errorParser;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleError(HttpCommand command, HttpResponse response) {
        try {
            HttpResponseException exception = new HttpResponseException(command, response);
            Set<ErrorResponse> errors = this.parseErrorsFromContentOrNull(response);
            if (errors != null) {
                exception = new GoGridResponseException(command, response, errors);
            }
            switch (response.getStatusCode()) {
                case 400: {
                    if (((ErrorResponse)Iterables.get(errors, (int)0)).getMessage().indexOf("No object found") != -1) {
                        exception = new ResourceNotFoundException(((ErrorResponse)Iterables.get(errors, (int)0)).getMessage(), (Throwable)exception);
                        break;
                    }
                }
                case 403: {
                    exception = new AuthorizationException(exception.getMessage(), (Throwable)exception);
                }
            }
            command.setException((Exception)exception);
        }
        finally {
            HttpUtils.releasePayload((HttpMessage)response);
        }
    }

    Set<ErrorResponse> parseErrorsFromContentOrNull(HttpResponse response) {
        if (response.getPayload() != null) {
            try {
                return this.errorParser.apply(response);
            }
            catch (Exception e) {
                return null;
            }
        }
        return null;
    }
}

