/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.binders;

import com.google.common.base.Preconditions;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.ws.rs.core.UriBuilder;
import org.jclouds.cloudstack.domain.ResourceLimit;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.utils.ModifyRequest;
import org.jclouds.rest.Binder;

public class ResourceLimitToQueryParams
implements Binder {
    private final Provider<UriBuilder> uriBuilderProvider;

    @Inject
    public ResourceLimitToQueryParams(Provider<UriBuilder> uriBuilderProvider) {
        this.uriBuilderProvider = (Provider)Preconditions.checkNotNull(uriBuilderProvider, (Object)"uriBuilderProvider");
    }

    public <R extends HttpRequest> R bindToRequest(R request, Object input) {
        Preconditions.checkArgument((boolean)(input instanceof ResourceLimit), (Object)"this binder is only valid for ResourceLimit");
        ResourceLimit limit = (ResourceLimit)input;
        request = ModifyRequest.addQueryParam(request, (String)"resourcetype", (Object)limit.getResourceType().getCode(), (UriBuilder)((UriBuilder)this.uriBuilderProvider.get()));
        request = ModifyRequest.addQueryParam(request, (String)"account", (Object)limit.getAccount(), (UriBuilder)((UriBuilder)this.uriBuilderProvider.get()));
        request = ModifyRequest.addQueryParam(request, (String)"domainid", (Object)limit.getDomainId(), (UriBuilder)((UriBuilder)this.uriBuilderProvider.get()));
        request = ModifyRequest.addQueryParam(request, (String)"max", (Object)limit.getMax(), (UriBuilder)((UriBuilder)this.uriBuilderProvider.get()));
        return request;
    }
}

