/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.domain;

public class ConfigurationEntry
implements Comparable<ConfigurationEntry> {
    private String category;
    private String description;
    private String name;
    private String value;

    public static Builder builder() {
        return new Builder();
    }

    ConfigurationEntry() {
    }

    public ConfigurationEntry(String category, String description, String name, String value) {
        this.category = category;
        this.description = description;
        this.name = name;
        this.value = value;
    }

    @Override
    public int compareTo(ConfigurationEntry arg0) {
        return this.name.compareTo(arg0.getName());
    }

    public String getCategory() {
        return this.category;
    }

    public String getDescription() {
        return this.description;
    }

    public String getName() {
        return this.name;
    }

    public String getValue() {
        return this.value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ConfigurationEntry that = (ConfigurationEntry)o;
        if (this.category != null ? !this.category.equals(that.category) : that.category != null) {
            return false;
        }
        if (this.description != null ? !this.description.equals(that.description) : that.description != null) {
            return false;
        }
        if (this.name != null ? !this.name.equals(that.name) : that.name != null) {
            return false;
        }
        return !(this.value != null ? !this.value.equals(that.value) : that.value != null);
    }

    public int hashCode() {
        int result = this.category != null ? this.category.hashCode() : 0;
        result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
        result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
        result = 31 * result + (this.value != null ? this.value.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "ConfigurationEntry{category='" + this.category + '\'' + ", description='" + this.description + '\'' + ", name='" + this.name + '\'' + ", value='" + this.value + '\'' + '}';
    }

    public static class Builder {
        private String category;
        private String description;
        private String name;
        private String value;

        public Builder category(String category) {
            this.category = category;
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder value(String value) {
            this.value = value;
            return this;
        }

        public ConfigurationEntry build() {
            return new ConfigurationEntry(this.category, this.description, this.name, this.value);
        }
    }
}

